/*
 * Decompiled with CFR 0.152.
 */
package net.cyanmarine.simpleveinminer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.cyanmarine.simpleveinminer.Constants;
import net.cyanmarine.simpleveinminer.client.SimpleVeinminerClient;
import net.cyanmarine.simpleveinminer.commands.CommandRegister;
import net.cyanmarine.simpleveinminer.commands.argumenttypes.ArgumentTypes;
import net.cyanmarine.simpleveinminer.config.SimpleConfig;
import net.cyanmarine.simpleveinminer.server.SimpleVeinminerServer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1820;
import net.minecraft.class_1831;
import net.minecraft.class_1834;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVeinminer
implements ModInitializer {
    public static final String MOD_ID = "simpleveinminer";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"simpleveinminer");
    public static final class_1928.class_4313<class_1928.class_4310> SERVER_SIDE_VEINMINING = GameRuleRegistry.register((String)"doServerSideVeinmining", (class_1928.class_5198)class_1928.class_5198.field_24100, (class_1928.class_4314)GameRuleFactory.createBooleanRule((boolean)false, (server, rule) -> {
        Collection players = PlayerLookup.all((MinecraftServer)server);
        boolean newValue = rule.method_20753();
        for (class_3222 player : players) {
            if (newValue) {
                player.method_43496(class_2561.method_30163((String)"Server side veinmining was turned on. Mining while shifting will veinmine"));
            } else {
                player.method_43496(class_2561.method_30163((String)"Server side veinmining was turned off"));
            }
            SimpleVeinminer.sendServerSideVeinminingUpdate(player, newValue);
        }
    }));
    static MinecraftServer server;
    private static ArrayList<UUID> playersVeinMining;
    private static HashMap<UUID, Integer> playersRadius;
    private static class_2680[] STATES;

    public static class_2960 getId(String name) {
        return new class_2960(MOD_ID, name);
    }

    private static ArrayList<class_2338> testAroundBlock(@Nullable ArrayList<class_2338> blocksTested, ArrayList<class_2338> blocksToBreak, int maxBlocks, class_1937 world, class_2680 compareTo, int radius, class_2338 currentPos, int depth, boolean debug, @Nullable List<String> tagList, boolean chainReactions, @Nullable class_1657 player, SimpleConfig.Restrictions restrictions) {
        if (blocksTested == null) {
            blocksTested = new ArrayList();
        }
        ArrayList<class_2338> blocksToCrawl = new ArrayList<class_2338>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (blocksToBreak.size() >= maxBlocks) {
                        return blocksToCrawl;
                    }
                    class_2338 testPos = currentPos.method_10069(x, y, z);
                    if (blocksTested.contains(testPos)) continue;
                    blocksTested.add(testPos);
                    if (blocksToBreak.size() >= maxBlocks || blocksToBreak.contains(testPos)) continue;
                    class_2680 testState = world.method_8320(testPos);
                    if (SimpleVeinminer.isSameBlock(testState, compareTo, tagList, player, restrictions)) {
                        if ((testState.method_27852(class_2246.field_10214) || testState.method_27852(class_2246.field_10238) || testState.method_27852(class_2246.field_10313)) && (blocksToBreak.contains(testPos.method_10084()) || blocksToBreak.contains(testPos.method_10074()))) continue;
                        if (chainReactions) {
                            boolean skip = false;
                            if (testState.method_26164(class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)SimpleVeinminer.getId("break_bottom_most")))) {
                                while (SimpleVeinminer.isSameBlock(world.method_8320(testPos.method_10074()), testState, null, player, restrictions)) {
                                    if (blocksToBreak.contains(testPos.method_10074())) {
                                        skip = true;
                                        break;
                                    }
                                    testPos = testPos.method_10074();
                                }
                                if (skip) continue;
                            }
                            if (testState.method_26164(class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)SimpleVeinminer.getId("break_top_most")))) {
                                while (SimpleVeinminer.isSameBlock(world.method_8320(testPos.method_10084()), testState, null, null, null)) {
                                    if (blocksToBreak.contains(testPos.method_10084())) {
                                        skip = true;
                                        break;
                                    }
                                    testPos = testPos.method_10084();
                                }
                                if (skip) continue;
                            }
                        }
                        blocksToBreak.add(testPos);
                        continue;
                    }
                    if (debug) {
                        world.method_8501(testPos, STATES[depth]);
                    }
                    if (blocksToCrawl.contains(testPos)) continue;
                    blocksToCrawl.add(testPos);
                }
            }
        }
        if (radius > 1 && depth == 0) {
            ArrayList crawlers = new ArrayList();
            crawlers.add(new ArrayList());
            ((ArrayList)crawlers.get(0)).add(new ArrayList<class_2338>(blocksToCrawl));
            for (int d = 0; d < crawlers.size() && d < radius - 1; ++d) {
                int t = 0;
                ArrayList _crawlers = (ArrayList)crawlers.get(d);
                ArrayList next = new ArrayList();
                for (int j = 0; j < _crawlers.size(); ++j) {
                    ArrayList crawler = (ArrayList)_crawlers.get(j);
                    for (int i = 0; i < crawler.size(); ++i) {
                        ++t;
                        class_2338 pos = (class_2338)crawler.get(i);
                        ArrayList<class_2338> newCrawler = SimpleVeinminer.testAroundBlock(blocksTested, blocksToBreak, maxBlocks, world, compareTo, radius, pos, 1 + d, debug, tagList, chainReactions, player, restrictions);
                        if (d >= radius - 2 || newCrawler.size() <= 0) continue;
                        ArrayList<class_2338> filteredCrawler = new ArrayList<class_2338>();
                        for (class_2338 newCrawlerPos : newCrawler) {
                            if (blocksToCrawl.contains(newCrawlerPos)) continue;
                            filteredCrawler.add(newCrawlerPos);
                            blocksToCrawl.add(newCrawlerPos);
                        }
                        if (filteredCrawler.isEmpty()) continue;
                        next.add(filteredCrawler);
                    }
                }
                if (next.isEmpty()) continue;
                crawlers.add(next);
            }
        }
        return blocksToCrawl;
    }

    public static ArrayList<class_2338> getBlocksToVeinmine(class_2338 pos, class_2680 state, int maxBlocks, int radius, SimpleConfig.Limits.SPREAD_ACCURACY spreadAccuracy, class_1657 player, boolean debug, boolean chainReactions) {
        class_1937 world = player.method_37908();
        ArrayList<class_2338> blocksToBreak = new ArrayList<class_2338>();
        ArrayList<class_2338> blocksTested = new ArrayList<class_2338>();
        boolean isDebug = debug && !world.method_8608();
        SimpleConfig.Restrictions.RestrictionTags rTags = SimpleVeinminer.getConfig().restrictions.restrictionTags;
        List<String> tagList = null;
        if (rTags.enabled) {
            Stream<String> tags = state.method_40144().filter(tag -> {
                for (String tagString : rTags.tags) {
                    if (!tagString.startsWith("#")) continue;
                    tagString = tagString.substring(1);
                    if (!tag.comp_327().toString().matches(tagString)) continue;
                    return true;
                }
                return false;
            }).map(tag -> "#" + tag.comp_327().toString());
            String id = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
            for (String tagString : rTags.tags) {
                if (tagString.startsWith("#") || !id.matches(tagString)) continue;
                tags = Stream.concat(tags, Stream.of(tagString));
            }
            tagList = tags.toList();
        }
        boolean n = false;
        boolean m = false;
        blocksToBreak.add(pos);
        for (int i = 0; i < maxBlocks && i < blocksToBreak.size(); ++i) {
            class_2338 currentPos = blocksToBreak.get(i);
            if (blocksToBreak.size() >= maxBlocks) {
                return blocksToBreak;
            }
            SimpleVeinminer.testAroundBlock(spreadAccuracy == SimpleConfig.Limits.SPREAD_ACCURACY.ACCURATE ? null : blocksTested, blocksToBreak, maxBlocks, world, state, radius, currentPos, 0, isDebug, tagList, chainReactions, player, SimpleVeinminer.getConfig().restrictions);
        }
        return blocksToBreak;
    }

    public static class_3965 getBlockHitResult(class_1657 player) {
        class_243 cameraPos = player.method_5836(1.0f);
        class_243 rotation = player.method_5828(1.0f);
        double reachDistance = player.method_7337() ? 5.0 : 4.5;
        class_243 combined = cameraPos.method_1031(rotation.field_1352 * reachDistance, rotation.field_1351 * reachDistance, rotation.field_1350 * reachDistance);
        return player.method_37908().method_17742(new class_3959(cameraPos, combined, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
    }

    public static int getMaxBlocks(class_1792 item) {
        SimpleConfig config = SimpleVeinminer.getConfig();
        int maxBlocks = config.limits.maxBlocks;
        if (config.limits.materialBasedLimits) {
            int limitingFactor = 6;
            if (item instanceof class_1831) {
                limitingFactor -= ((class_1831)item).method_8022().method_8024() + 1;
            } else if (item instanceof class_1820) {
                limitingFactor -= class_1834.field_8923.method_8024() + 1;
            }
            maxBlocks /= Math.max(1, limitingFactor);
        }
        return maxBlocks;
    }

    public static int getVeinminingRadius(class_1657 player) {
        int playerRadius;
        int serverRadius = SimpleVeinminer.getConfig().limits.radius;
        int n = playerRadius = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? SimpleVeinminerClient.getConfig().clientRadius : playersRadius.getOrDefault(player.method_5667(), serverRadius);
        if (playerRadius <= 0) {
            playerRadius = 1;
        }
        return Math.min(playerRadius, serverRadius);
    }

    public static SimpleConfig.Limits.SPREAD_ACCURACY getSpreadAccuracy() {
        return SimpleVeinminer.getConfig().limits.spreadAccuracy;
    }

    public static boolean isDebug() {
        return SimpleVeinminer.getConfig().debug;
    }

    private static boolean isSameBlock(class_2680 state, class_2680 compareTo, @Nullable List<String> tagList, @Nullable class_1657 player, @Nullable SimpleConfig.Restrictions restrictions) {
        if (state.method_26204().equals(compareTo.method_26204())) {
            return true;
        }
        if (state.method_26215() || compareTo.method_26215()) {
            return false;
        }
        if (player != null && restrictions != null && !SimpleVeinminer.canVeinmine(player, null, null, state, restrictions)) {
            return false;
        }
        if (tagList != null) {
            String id = class_7923.field_41175.method_10221((Object)state.method_26204()).toString();
            for (String tag : tagList) {
                if (tag.startsWith("#")) {
                    class_2960 identifier = new class_2960(tag.substring(1));
                    if (!state.method_26164(class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)identifier))) continue;
                    return true;
                }
                if (!id.matches(tag)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean listIncludes(class_2248 block, SimpleConfig.Restrictions restrictions) {
        for (int i = 0; i < restrictions.restrictionList.list.size(); ++i) {
            class_2248 compareTo;
            String name = restrictions.restrictionList.list.get(i);
            class_2960 identifier = new class_2960(name.replaceAll("[^a-z0-9-_:/]", ""));
            if (!(name.startsWith("#") ? block.method_9564().method_26164(class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)identifier)) : (compareTo = (class_2248)class_7923.field_41175.method_10223(identifier)).equals(block))) continue;
            return true;
        }
        return false;
    }

    public static boolean canVeinmine(class_1657 player, @Nullable class_1937 world, @Nullable class_2338 pos, class_2680 state, SimpleConfig.Restrictions restrictions) {
        boolean isInList;
        boolean sendMessage;
        if (restrictions.creativeBypass && player.method_7337()) {
            return true;
        }
        class_1792 hand = player.method_6047().method_7909();
        boolean bl = sendMessage = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && SimpleVeinminerClient.getConfig().showRestrictionMessages;
        if (restrictions.restrictionList.listType != SimpleConfig.Restrictions.RestrictionList.ListType.NONE && restrictions.restrictionList.listType == SimpleConfig.Restrictions.RestrictionList.ListType.BLACKLIST == (isInList = SimpleVeinminer.listIncludes(state.method_26204(), restrictions))) {
            return false;
        }
        if (!(restrictions.canVeinmineWithEmptyHand || hand instanceof class_1831 || hand instanceof class_1820)) {
            if (sendMessage) {
                player.method_7353((class_2561)class_2561.method_43471((String)"messages.simpleveinminer.restriction.tool"), true);
            }
            return false;
        }
        if (restrictions.canOnlyUseSuitableTools && !player.method_6047().method_7951(state)) {
            if (sendMessage) {
                player.method_7353((class_2561)class_2561.method_43471((String)"messages.simpleveinminer.restriction.specificTool"), true);
            }
            return false;
        }
        if (!restrictions.canVeinmineHungry && player.method_7344().method_7586() < 1) {
            if (sendMessage) {
                player.method_7353((class_2561)class_2561.method_43471((String)"messages.simpleveinminer.restriction.hungry"), true);
            }
            return false;
        }
        return true;
    }

    public static void sendServerSideVeinminingUpdate(class_3222 player, boolean value) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_52964(value);
        ServerPlayNetworking.send((class_3222)player, (class_2960)Constants.SERVERSIDE_UPDATE, (class_2540)buf);
    }

    public static void syncConfig(class_3222 player) {
        SimpleConfig config = SimpleVeinminer.getConfig();
        class_2540 buf = config.WritePacket();
        ServerPlayNetworking.send((class_3222)player, (class_2960)Constants.CONFIG_SYNC, (class_2540)buf);
    }

    public static void SyncConfigForAllPlayers() {
        if (server == null) {
            return;
        }
        for (class_3222 player : PlayerLookup.all((MinecraftServer)server)) {
            SimpleVeinminer.syncConfig(player);
        }
    }

    public static boolean isVeinmining(class_1657 player) {
        return player.method_5715() && player.method_37908().method_8450().method_8355(SERVER_SIDE_VEINMINING) || playersVeinMining.contains(player.method_5667());
    }

    private static void setVeinmining(class_1657 player, boolean isVeinMining) {
        if (isVeinMining) {
            playersVeinMining.add(player.method_5667());
        } else {
            playersVeinMining.remove(player.method_5667());
        }
    }

    private static void setPlayerVeinminingRadius(class_1657 player, int radius) {
        playersRadius.put(player.method_5667(), radius);
    }

    public static SimpleConfig getConfig() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return SimpleVeinminerClient.getConfig();
        }
        return SimpleVeinminerServer.getConfig();
    }

    public static class_2338[] getNeighbors(class_2338 pos) {
        return new class_2338[]{pos.method_10084(), pos.method_10074(), pos.method_10067(), pos.method_10078(), pos.method_10095(), pos.method_10072()};
    }

    public void onInitialize() {
        playersVeinMining = new ArrayList();
        playersRadius = new HashMap();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Constants.NETWORKING_VEINMINE, (server, player, handler, buf, sender) -> {
            boolean isVeinMining = buf.readBoolean();
            server.execute(() -> SimpleVeinminer.setVeinmining((class_1657)player, isVeinMining));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Constants.NETWORKING_RADIUS, (server, player, handler, buf, sender) -> {
            int radius = buf.readInt();
            server.execute(() -> SimpleVeinminer.setPlayerVeinminingRadius((class_1657)player, radius));
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            boolean serverSideVeinmining = server.method_3767().method_8355(SERVER_SIDE_VEINMINING);
            class_3222 player = handler.method_32311();
            SimpleVeinminer.sendServerSideVeinminingUpdate(player, serverSideVeinmining);
            if (serverSideVeinmining) {
                player.method_43496((class_2561)class_2561.method_43471((String)"This server has server side veinmining turned on. Mining while shifting will veinmine"));
            }
            SimpleVeinminer.syncConfig(player);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server1) -> SimpleVeinminer.setVeinmining((class_1657)handler.method_32311(), false));
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            SimpleVeinminer.server = server;
        });
        new ArgumentTypes();
        new CommandRegister();
        LOGGER.info("Simple VeinMiner initialized");
    }

    static {
        STATES = new class_2680[]{class_2246.field_10272.method_9564(), class_2246.field_10227.method_9564(), class_2246.field_10049.method_9564(), class_2246.field_10157.method_9564(), class_2246.field_10357.method_9564(), class_2246.field_10248.method_9564(), class_2246.field_10271.method_9564(), class_2246.field_10060.method_9564(), class_2246.field_10399.method_9564(), class_2246.field_10574.method_9564(), class_2246.field_10317.method_9564(), class_2246.field_10073.method_9564(), class_2246.field_9997.method_9564(), class_2246.field_10555.method_9564(), class_2246.field_9996.method_9564(), class_2246.field_10087.method_9564()};
    }
}

