/*
 * Decompiled with CFR 0.152.
 */
package net.cyanmarine.simpleveinminer.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.cyanmarine.simpleveinminer.Constants;
import net.cyanmarine.simpleveinminer.commands.CommandRegisterClient;
import net.cyanmarine.simpleveinminer.config.SimpleConfig;
import net.cyanmarine.simpleveinminer.config.SimpleConfigClient;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4666;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class SimpleVeinminerClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"simpleveinminer - client");
    public static boolean isVeinMiningServerSide = false;
    public static AtomicBoolean isInstalledOnServerSide = new AtomicBoolean(false);
    static SimpleConfig.SimpleConfigCopy worldConfig;
    private static SimpleConfigClient config;
    public static class_304 veinMineKeybind;
    public static class_304 increaseRadius;
    public static class_304 decreaseRadius;
    public static class_304 freezePreview;
    public static boolean veinMining;
    public static boolean previewFrozen;
    public static class_2680 currentlyOutliningState;
    public static ArrayList<class_2338> blocksToHighlight;

    public static SimpleConfig.SimpleConfigCopy getWorldConfig() {
        if (worldConfig == null) {
            return SimpleConfig.SimpleConfigCopy.from(config);
        }
        return worldConfig;
    }

    public static SimpleConfigClient getConfig() {
        return config;
    }

    public static void drawBox(class_287 buffer, Matrix4f positionMatrix, float red, float green, float blue, float alpha, class_238 box, @Nullable class_2338 pos, @Nullable List<class_2338> blocks, boolean ignoreNeighbors) {
        boolean b;
        float minX = (float)box.field_1323;
        float maxX = (float)box.field_1320;
        float minY = (float)box.field_1322;
        float maxY = (float)box.field_1325;
        float minZ = (float)box.field_1321;
        float maxZ = (float)box.field_1324;
        boolean bl = b = ignoreNeighbors || pos == null || blocks == null;
        if (b || minZ > 0.0f || !blocks.contains(pos.method_10095())) {
            buffer.method_22918(positionMatrix, minX, maxY, minZ).method_22915(red, green, blue, alpha).method_22913(minX, minY).method_1344();
            buffer.method_22918(positionMatrix, minX, minY, minZ).method_22915(red, green, blue, alpha).method_22913(minX, maxY).method_1344();
            buffer.method_22918(positionMatrix, maxX, minY, minZ).method_22915(red, green, blue, alpha).method_22913(maxX, maxY).method_1344();
            buffer.method_22918(positionMatrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha).method_22913(maxX, minY).method_1344();
        }
        if (b || maxZ < 1.0f || !blocks.contains(pos.method_10072())) {
            buffer.method_22918(positionMatrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha).method_22913(minX, minY).method_1344();
            buffer.method_22918(positionMatrix, minX, minY, maxZ).method_22915(red, green, blue, alpha).method_22913(minX, maxY).method_1344();
            buffer.method_22918(positionMatrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha).method_22913(maxX, maxY).method_1344();
            buffer.method_22918(positionMatrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha).method_22913(maxX, minY).method_1344();
        }
        if (b || maxX < 1.0f || !blocks.contains(pos.method_10078())) {
            buffer.method_22918(positionMatrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha).method_22913(minY, maxZ).method_1344();
            buffer.method_22918(positionMatrix, maxX, minY, minZ).method_22915(red, green, blue, alpha).method_22913(minY, minZ).method_1344();
            buffer.method_22918(positionMatrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha).method_22913(maxY, minZ).method_1344();
            buffer.method_22918(positionMatrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha).method_22913(maxY, maxZ).method_1344();
        }
        if (b || minX > 0.0f || !blocks.contains(pos.method_10067())) {
            buffer.method_22918(positionMatrix, minX, minY, maxZ).method_22915(red, green, blue, alpha).method_22913(minY, maxZ).method_1344();
            buffer.method_22918(positionMatrix, minX, minY, minZ).method_22915(red, green, blue, alpha).method_22913(minY, minZ).method_1344();
            buffer.method_22918(positionMatrix, minX, maxY, minZ).method_22915(red, green, blue, alpha).method_22913(maxY, minZ).method_1344();
            buffer.method_22918(positionMatrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha).method_22913(maxY, maxZ).method_1344();
        }
        if (b || maxY < 1.0f || !blocks.contains(pos.method_10084())) {
            buffer.method_22918(positionMatrix, maxX, maxY, minZ).method_22915(red, green, blue, alpha).method_22913(maxX, minZ).method_1344();
            buffer.method_22918(positionMatrix, minX, maxY, minZ).method_22915(red, green, blue, alpha).method_22913(minX, minZ).method_1344();
            buffer.method_22918(positionMatrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha).method_22913(minX, maxZ).method_1344();
            buffer.method_22918(positionMatrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha).method_22913(maxX, maxZ).method_1344();
        }
        if (b || minY > 0.0f || !blocks.contains(pos.method_10074())) {
            buffer.method_22918(positionMatrix, maxX, minY, minZ).method_22915(red, green, blue, alpha).method_22913(maxX, minZ).method_1344();
            buffer.method_22918(positionMatrix, minX, minY, minZ).method_22915(red, green, blue, alpha).method_22913(minX, minZ).method_1344();
            buffer.method_22918(positionMatrix, minX, minY, maxZ).method_22915(red, green, blue, alpha).method_22913(minX, maxZ).method_1344();
            buffer.method_22918(positionMatrix, maxX, minY, maxZ).method_22915(red, green, blue, alpha).method_22913(maxX, maxZ).method_1344();
        }
    }

    public static void drawOutline(class_287 buffer, Matrix4f positionMatrix, float red, float green, float blue, float alpha, class_265 shape, @Nullable class_2338 pos, @Nullable List<class_2338> blocks, boolean ignoreNeighbors, class_4587 matrices) {
        shape.method_1104((_minX, _minY, _minZ, _maxX, _maxY, _maxZ) -> {
            float minX = (float)_minX;
            float minY = (float)_minY;
            float minZ = (float)_minZ;
            float maxX = (float)_maxX;
            float maxY = (float)_maxY;
            float maxZ = (float)_maxZ;
            float size = 0.01f;
            buffer.method_22918(positionMatrix, minX, minY + size, minZ).method_22915(red, green, blue, alpha).method_22913(minX, minY).method_1344();
            buffer.method_22918(positionMatrix, minX, minY - size, minZ).method_22915(red, green, blue, alpha).method_22913(minX, maxY).method_1344();
            buffer.method_22918(positionMatrix, maxX, minY - size, minZ).method_22915(red, green, blue, alpha).method_22913(maxX, maxY).method_1344();
            buffer.method_22918(positionMatrix, maxX, minY + size, minZ).method_22915(red, green, blue, alpha).method_22913(maxX, minY).method_1344();
            buffer.method_22918(positionMatrix, minX - size, maxY, maxZ).method_22915(red, green, blue, alpha).method_22913(minX, minY).method_1344();
            buffer.method_22918(positionMatrix, minX - size, minY, maxZ).method_22915(red, green, blue, alpha).method_22913(minX, maxY).method_1344();
            buffer.method_22918(positionMatrix, minX + size, minY, maxZ).method_22915(red, green, blue, alpha).method_22913(maxX, maxY).method_1344();
            buffer.method_22918(positionMatrix, minX + size, maxY, maxZ).method_22915(red, green, blue, alpha).method_22913(maxX, minY).method_1344();
            buffer.method_22918(positionMatrix, minX, minY + size, minZ).method_22915(red, green, blue, alpha).method_22913(minX, minY).method_1344();
            buffer.method_22918(positionMatrix, minX, minY - size, minZ).method_22915(red, green, blue, alpha).method_22913(minX, maxY).method_1344();
            buffer.method_22918(positionMatrix, minX, minY - size, maxZ).method_22915(red, green, blue, alpha).method_22913(maxX, maxY).method_1344();
            buffer.method_22918(positionMatrix, minX, minY + size, maxZ).method_22915(red, green, blue, alpha).method_22913(maxX, minY).method_1344();
        });
    }

    private void changeClientRadius(class_310 client, int change) {
        SimpleConfigClient config = SimpleVeinminerClient.getConfig();
        int newRadius = class_3532.method_15340((int)(config.clientRadius + change), (int)1, (int)config.limits.radius);
        config.setClientRadius(newRadius);
        client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"messages.simpleveinminer.radiusChanged", (Object[])new Object[]{newRadius}), true);
        class_2540 buf = PacketByteBufs.create();
        buf.method_53002(newRadius);
        ClientPlayNetworking.send((class_2960)Constants.NETWORKING_RADIUS, (class_2540)buf);
    }

    public void onInitializeClient() {
        veinMining = false;
        config = new SimpleConfigClient();
        config.load();
        worldConfig = SimpleConfig.SimpleConfigCopy.from(config);
        new CommandRegisterClient();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (veinMining != veinMineKeybind.method_1434()) {
                boolean bl = veinMining = !veinMining;
                if (SimpleVeinminerClient.config.keybindToggles) {
                    client.field_1724.method_7353((class_2561)(veinMining ? class_2561.method_43471((String)"messages.simpleveinminer.veinminingToggled.on") : class_2561.method_43471((String)"messages.simpleveinminer.veinminingToggled.off")), true);
                }
                class_2540 buf = PacketByteBufs.create();
                buf.method_52964(veinMining);
                ClientPlayNetworking.send((class_2960)Constants.NETWORKING_VEINMINE, (class_2540)buf);
            }
            if (increaseRadius.method_1436()) {
                this.changeClientRadius(client, 1);
            }
            if (decreaseRadius.method_1436()) {
                this.changeClientRadius(client, -1);
            }
            if (freezePreview.method_1436()) {
                previewFrozen = !previewFrozen;
                client.field_1724.method_7353((class_2561)(previewFrozen ? class_2561.method_43471((String)"messages.simpleveinminer.previewFrozen") : class_2561.method_43471((String)"messages.simpleveinminer.previewUnfrozen")), true);
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            worldConfig = null;
            isInstalledOnServerSide.set(false);
        });
        ClientPlayConnectionEvents.INIT.register((handler, client) -> {
            worldConfig = null;
            isInstalledOnServerSide.set(false);
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Constants.CONFIG_SYNC, (client, handler, buf, responseSender) -> {
            buf.method_52938();
            client.execute(() -> {
                worldConfig = SimpleConfig.copy(buf);
                isInstalledOnServerSide.set(true);
                buf.release();
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Constants.SERVERSIDE_UPDATE, (client, handler, buf, responseSender) -> {
            boolean newValue = buf.readBoolean();
            client.execute(() -> {
                isVeinMiningServerSide = newValue;
            });
        });
        LOGGER.info("Simple VeinMiner initialized");
    }

    static {
        veinMineKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_4666("key.simpleveinminer.veinminingKey", 96, "key.simpleveinminer.veinminerCategory", () -> SimpleVeinminerClient.config.keybindToggles));
        increaseRadius = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.simpleveinminer.increaseRadius", 93, "key.simpleveinminer.veinminerCategory"));
        decreaseRadius = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.simpleveinminer.decreaseRadius", 91, "key.simpleveinminer.veinminerCategory"));
        freezePreview = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.simpleveinminer.freezePreview", -1, "key.simpleveinminer.veinminerCategory"));
        previewFrozen = false;
    }
}

