/*
 * Decompiled with CFR 0.152.
 */
package net.cyanmarine.simpleveinminer.commands.argumenttypes;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.cyanmarine.simpleveinminer.SimpleVeinminer;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class RestrictionListArgumentType
implements ArgumentType<String> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stone", "minecraft:stone", "#stone", "#minecraft:stone");

    public static String getListMember(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        return (String)context.getArgument(name, String.class);
    }

    public static RestrictionListArgumentType listItem() {
        return new RestrictionListArgumentType();
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int argBeginning = reader.getCursor();
        if (!reader.canRead()) {
            reader.skip();
        }
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        String item = reader.getString().substring(argBeginning, reader.getCursor());
        if (SimpleVeinminer.getConfig().restrictions.restrictionList.list.contains("minecraft:" + item)) {
            return "minecraft:" + item;
        }
        if (SimpleVeinminer.getConfig().restrictions.restrictionList.list.contains(item)) {
            return item;
        }
        throw new SimpleCommandExceptionType((Message)class_2561.method_30163((String)("Invalid block: " + item))).createWithContext((ImmutableStringReader)reader);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        for (String item : SimpleVeinminer.getConfig().restrictions.restrictionList.list) {
            if (!item.toLowerCase().startsWith(builder.getRemainingLowerCase()) && !item.toLowerCase().startsWith("minecraft:" + builder.getRemainingLowerCase())) continue;
            builder.suggest(item);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

