/*
 * Decompiled with CFR 0.152.
 */
package net.cyanmarine.simpleveinminer.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.lortseam.completeconfig.api.ConfigContainer;
import me.lortseam.completeconfig.api.ConfigEntries;
import me.lortseam.completeconfig.api.ConfigEntry;
import me.lortseam.completeconfig.api.ConfigGroup;
import me.lortseam.completeconfig.data.Config;
import net.cyanmarine.simpleveinminer.SimpleVeinminer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;

public class SimpleConfig
extends Config
implements ConfigContainer {
    @ConfigEntry
    public boolean placeInInventory = false;
    @ConfigEntry
    public boolean debug = false;
    @ConfigContainer.Transitive
    public Limits limits = new Limits();
    @ConfigContainer.Transitive
    public Restrictions restrictions = new Restrictions();
    @ConfigContainer.Transitive
    public Exhaustion exhaustion = new Exhaustion();
    @ConfigContainer.Transitive
    public Durability durability = new Durability();

    public SimpleConfig() {
        super("simpleveinminer", new ConfigContainer[0]);
    }

    public static SimpleConfigCopy copy(class_2540 buf) {
        return new SimpleConfigCopy(buf);
    }

    public void reset() {
        this.placeInInventory = false;
        this.limits = new Limits();
        this.restrictions = new Restrictions();
        this.exhaustion = new Exhaustion();
        this.durability = new Durability();
        SimpleConfig.syncConfig();
    }

    public static void syncConfig() {
        SimpleVeinminer.getConfig().save();
        SimpleVeinminer.SyncConfigForAllPlayers();
    }

    public void setPlaceInInventory(boolean placeInInventory) {
        this.placeInInventory = placeInInventory;
        SimpleConfig.syncConfig();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        SimpleConfig.syncConfig();
    }

    public class_2540 WritePacket() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_52964(this.restrictions.canVeinmineHungry);
        buf.method_52964(this.restrictions.canVeinmineWithEmptyHand);
        buf.method_52964(this.restrictions.creativeBypass);
        buf.method_52964(this.restrictions.canOnlyUseSuitableTools);
        buf.method_10817((Enum)this.restrictions.restrictionList.listType);
        buf.method_10814(String.join((CharSequence)";", this.restrictions.restrictionList.list));
        buf.method_53002(this.limits.maxBlocks);
        buf.method_52964(this.limits.materialBasedLimits);
        return buf;
    }

    @ConfigEntries(includeAll=true)
    public static class Limits
    implements ConfigGroup {
        public int maxBlocks = 150;
        public boolean materialBasedLimits = false;
        @ConfigEntry.BoundedInteger(min=1)
        public int radius = 1;
        public SPREAD_ACCURACY spreadAccuracy = SPREAD_ACCURACY.ACCURATE;

        public void setMaxBlocks(int maxBlocks) {
            this.maxBlocks = maxBlocks;
            SimpleConfig.syncConfig();
        }

        public void setMaterialBasedLimits(boolean materialBasedLimits) {
            this.materialBasedLimits = materialBasedLimits;
            SimpleConfig.syncConfig();
        }

        public void setRadius(int radius) {
            if (radius < 1) {
                radius = 1;
            }
            this.radius = radius;
            SimpleConfig.syncConfig();
        }

        public void setAccurateSpread(SPREAD_ACCURACY spreadAccuracy) {
            this.spreadAccuracy = spreadAccuracy;
            SimpleConfig.syncConfig();
        }

        public static enum SPREAD_ACCURACY {
            KINDA_ACCURATE,
            ACCURATE;

        }
    }

    @ConfigEntries(includeAll=true)
    public static class Restrictions
    implements ConfigGroup {
        public boolean canVeinmineHungry = false;
        public boolean canVeinmineWithEmptyHand = true;
        public boolean creativeBypass = false;
        public boolean keepToolFromBreaking = true;
        public boolean onlyBreakBottomBlockForChainReactions = false;
        @ConfigEntry(comment="Will only allow to veinmine wood using an axe, dirt using a shovel, stone using a pickaxe, etc.")
        public boolean canOnlyUseSuitableTools = false;
        @ConfigContainer.Transitive
        public RestrictionList restrictionList = new RestrictionList();
        @ConfigContainer.Transitive
        public RestrictionTags restrictionTags = new RestrictionTags();

        public void setKeepToolFromBreaking(boolean keepToolFromBreaking) {
            this.keepToolFromBreaking = keepToolFromBreaking;
            SimpleConfig.syncConfig();
        }

        public void setCanVeinmineWithEmptyHand(boolean canVeinmineWithEmptyHand) {
            this.canVeinmineWithEmptyHand = canVeinmineWithEmptyHand;
            SimpleConfig.syncConfig();
        }

        public void setCreativeBypass(boolean creativeBypass) {
            this.creativeBypass = creativeBypass;
            SimpleConfig.syncConfig();
        }

        public void setCanVeinmineHungry(boolean canVeinmineHungry) {
            this.canVeinmineHungry = canVeinmineHungry;
            SimpleConfig.syncConfig();
        }

        public void setCanOnlyUseSuitableTools(boolean canOnlyUseSuitableTools) {
            this.canOnlyUseSuitableTools = canOnlyUseSuitableTools;
            SimpleConfig.syncConfig();
        }

        @ConfigEntries(includeAll=false)
        public static class RestrictionList
        implements ConfigGroup {
            @ConfigEntry(comment="Valid values are NONE, BLACKLIST, and WHITELIST")
            @ConfigEntry.Dropdown
            public ListType listType = ListType.NONE;
            @ConfigEntry(comment="More information at https://github.com/PrincessCyanMarine/Simple-Veinminer/wiki/Whitelist-and-Blacklist")
            public List<String> list = Arrays.asList("#c:logs", "#c:ores");

            public void setList(List<String> list) {
                this.list = list;
                SimpleConfig.syncConfig();
            }

            public void add(String value) {
                if (this.list.contains(value)) {
                    return;
                }
                ArrayList<String> newList = new ArrayList<String>(this.list);
                newList.add(value);
                this.setList(newList);
                SimpleConfig.syncConfig();
            }

            public void remove(String value) {
                this.list.remove(value);
                SimpleConfig.syncConfig();
            }

            public void setListType(ListType listType) {
                this.listType = listType;
                SimpleConfig.syncConfig();
            }

            public static enum ListType {
                NONE,
                WHITELIST,
                BLACKLIST;

            }
        }

        @ConfigEntries(includeAll=true)
        public static class RestrictionTags
        implements ConfigGroup {
            public boolean enabled = true;
            public List<String> tags = Arrays.asList("#c:.+_ores", "minecraft:(tall_)?grass", "minecraft:(large_)?fern");

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
                SimpleConfig.syncConfig();
            }

            public void setTags(List<String> tags) {
                this.tags = tags;
                SimpleConfig.syncConfig();
            }

            public void add(String value) {
                if (this.tags.contains(value)) {
                    return;
                }
                ArrayList<String> newList = new ArrayList<String>(this.tags);
                newList.add(value);
                this.setTags(newList);
                SimpleConfig.syncConfig();
            }

            public void remove(String value) {
                if (!this.tags.contains(value)) {
                    return;
                }
                ArrayList<String> newList = new ArrayList<String>(this.tags);
                newList.remove(value);
                this.setTags(newList);
                SimpleConfig.syncConfig();
            }

            public void clear() {
                this.tags = new ArrayList<String>();
                SimpleConfig.syncConfig();
            }
        }
    }

    @ConfigEntries(includeAll=true)
    public static class Exhaustion
    implements ConfigGroup {
        public boolean exhaust = true;
        public double baseValue = 0.3;
        public boolean exhaustionBasedOnHardness = true;
        public double hardnessWeight = 0.1;

        public void setExhaust(boolean exhaust) {
            this.exhaust = exhaust;
            SimpleVeinminer.getConfig().save();
        }

        public void setBaseValue(double baseValue) {
            this.baseValue = baseValue;
            SimpleVeinminer.getConfig().save();
        }

        public void setExhaustionBasedOnHardness(boolean exhaustionBasedOnHardness) {
            this.exhaustionBasedOnHardness = exhaustionBasedOnHardness;
            SimpleVeinminer.getConfig().save();
        }

        public void setHardnessWeight(double hardnessWeight) {
            this.hardnessWeight = hardnessWeight;
            SimpleVeinminer.getConfig().save();
        }
    }

    @ConfigEntries(includeAll=true)
    public static class Durability
    implements ConfigGroup {
        public double damageMultiplier = 1.0;
        public double swordMultiplier = 2.0;
        public boolean consumeOnInstantBreak = false;

        public void setDamageMultiplier(double damageMultiplier) {
            this.damageMultiplier = damageMultiplier;
            SimpleVeinminer.getConfig().save();
        }

        public void setSwordMultiplier(double swordMultiplier) {
            this.swordMultiplier = swordMultiplier;
            SimpleVeinminer.getConfig().save();
        }

        public void setConsumeOnInstantBreak(boolean consumeOnInstantBreak) {
            this.consumeOnInstantBreak = consumeOnInstantBreak;
            SimpleVeinminer.getConfig().save();
        }
    }

    public static class SimpleConfigCopy {
        public Restrictions restrictions = new Restrictions();
        public Limits limits = new Limits();

        private SimpleConfigCopy() {
        }

        SimpleConfigCopy(class_2540 buf) {
            this.restrictions.canVeinmineHungry = buf.readBoolean();
            this.restrictions.canVeinmineWithEmptyHand = buf.readBoolean();
            this.restrictions.creativeBypass = buf.readBoolean();
            this.restrictions.canOnlyUseSuitableTools = buf.readBoolean();
            this.restrictions.restrictionList.listType = (Restrictions.RestrictionList.ListType)buf.method_10818(Restrictions.RestrictionList.ListType.class);
            this.restrictions.restrictionList.list = Arrays.stream(buf.method_19772().split(";")).toList();
            this.limits.maxBlocks = buf.readInt();
            this.limits.materialBasedLimits = buf.readBoolean();
        }

        public static SimpleConfigCopy from(SimpleConfig config) {
            SimpleConfigCopy res = new SimpleConfigCopy();
            res.restrictions = config.restrictions;
            res.limits = config.limits;
            return res;
        }
    }
}

