/*
 * Decompiled with CFR 0.152.
 */
package net.cyanmarine.simpleveinminer.mixin;

import java.util.ArrayList;
import java.util.List;
import net.cyanmarine.simpleveinminer.SimpleVeinminer;
import net.cyanmarine.simpleveinminer.config.SimpleConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2248.class})
public abstract class BlockMixin {
    @Shadow
    public static List<class_1799> method_9609(class_2680 state, class_3218 world, class_2338 pos, @Nullable class_2586 blockEntity, @Nullable class_1297 entity, class_1799 stack) {
        return null;
    }

    @Shadow
    public static void method_9577(class_1937 world, class_2338 pos, class_1799 stack) {
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/block/Block;onBreak(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/block/BlockState;"})
    public void onBreak(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, CallbackInfoReturnable<class_2680> cir) {
        if (!world.method_8608() && SimpleVeinminer.isVeinmining(player) && SimpleVeinminer.canVeinmine(player, world, pos, state, SimpleVeinminer.getConfig().restrictions)) {
            this.veinMine(world, pos, state, player);
        }
    }

    private void veinMine(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_1799 hand = player.method_6047();
        class_1792 handItem = player.method_6047().method_7909();
        SimpleConfig config = SimpleVeinminer.getConfig();
        SimpleConfig.Exhaustion exhaustion = config.exhaustion;
        SimpleConfig.Durability durability = config.durability;
        double damageMultiplier = durability.damageMultiplier;
        if (handItem instanceof class_1829 || handItem instanceof class_1835) {
            damageMultiplier *= durability.swordMultiplier;
        }
        boolean debug = SimpleVeinminer.isDebug();
        ArrayList<class_2338> blocksToBreak = SimpleVeinminer.getBlocksToVeinmine(pos, state, SimpleVeinminer.getMaxBlocks(handItem), SimpleVeinminer.getVeinminingRadius(player), SimpleVeinminer.getSpreadAccuracy(), player, debug, config.restrictions.onlyBreakBottomBlockForChainReactions);
        if (debug) {
            world.method_8501(pos, class_2246.field_9987.method_9564());
        }
        for (int i = 0; i < blocksToBreak.size(); ++i) {
            boolean doDamage;
            class_2338 currentPos = blocksToBreak.get(i);
            if (debug) {
                world.method_8501(currentPos, class_2246.field_9987.method_9564());
                continue;
            }
            class_2680 currentState = world.method_8320(currentPos);
            if (currentState.method_26215()) continue;
            class_2248 currentBlock = currentState.method_26204();
            class_2586 currentBlockEntity = world.method_8321(currentPos);
            boolean willDrop = this.shouldDrop(player, hand, currentState);
            List<class_1799> stacks = BlockMixin.method_9609(currentState, (class_3218)world, currentPos, currentBlockEntity, (class_1297)player, hand);
            if (willDrop) {
                stacks.forEach(stack -> {
                    if (SimpleVeinminer.getConfig().placeInInventory) {
                        player.method_31548().method_7398(stack);
                    } else {
                        BlockMixin.method_9577(world, pos, stack);
                    }
                });
            }
            currentState.method_26180((class_3218)world, currentPos, hand, willDrop);
            player.method_7259(class_3468.field_15427.method_14956((Object)currentBlock));
            if (willDrop && stacks.isEmpty() && currentState.method_27852(class_2246.field_10295) && !world.method_8320(pos.method_10074()).method_26215()) {
                world.method_8501(currentPos, class_2246.field_10382.method_9564());
            } else {
                world.method_8650(currentPos, false);
            }
            boolean bl = doDamage = i > 0 && this.shouldDamage(player, hand, currentBlock, durability);
            if (doDamage) {
                hand.method_7970((int)damageMultiplier, player.method_6051(), (class_3222)player);
            }
            if (exhaustion.exhaust) {
                double totalExhausted = exhaustion.baseValue + (exhaustion.exhaustionBasedOnHardness ? (double)currentBlock.method_36555() * exhaustion.hardnessWeight : 0.0);
                player.method_7322((float)totalExhausted);
            }
            if (doDamage && (hand.method_7919() >= hand.method_7936() || config.restrictions.keepToolFromBreaking && hand.method_7919() >= hand.method_7936() - 2)) break;
        }
    }

    public boolean shouldDrop(class_1657 player, class_1799 hand, class_2680 state) {
        return !player.method_7337() && (!state.method_29291() || hand.method_7951(state));
    }

    public boolean shouldDamage(class_1657 player, class_1799 hand, class_2248 block, SimpleConfig.Durability durability) {
        class_1792 handItem = hand.method_7909();
        return !(player.method_7337() || !hand.method_7963() || !durability.consumeOnInstantBreak && !(block.method_36555() > 0.0f) || !(handItem instanceof class_1829) && !(handItem instanceof class_1835) && !(handItem instanceof class_1766) && !(handItem instanceof class_1820));
    }
}

