/*
 * Decompiled with CFR 0.152.
 */
package net.cyanmarine.simpleveinminer.mixin;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import me.shedaniel.math.Color;
import net.cyanmarine.simpleveinminer.SimpleVeinminer;
import net.cyanmarine.simpleveinminer.client.SimpleVeinminerClient;
import net.cyanmarine.simpleveinminer.config.SimpleConfig;
import net.cyanmarine.simpleveinminer.config.SimpleConfigClient;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3726;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class WorldRendererMixin {
    class_1792 holding;
    class_2338 currentlyOutliningPos;
    ArrayList<class_2338> beingBroken;
    float red;
    float green;
    float blue;
    float alpha;
    int delay1 = 0;
    int delay2 = 0;
    boolean resetCountdown = false;
    @Shadow
    @Nullable
    private class_638 field_4085;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<class_3191>> field_20950;
    @Shadow
    @Final
    private class_310 field_4088;

    @Shadow
    protected static void method_3291(class_4587 matrices, class_4588 vertexConsumer, class_265 shape, double offsetX, double offsetY, double offsetZ, float red, float green, float blue, float alpha) {
    }

    @Shadow
    protected abstract void method_22987(class_3191 var1);

    private void renderPreview(class_1657 player, class_4587 matrices) {
        assert (this.field_4085 != null);
        assert (SimpleVeinminerClient.blocksToHighlight != null);
        SimpleConfigClient config = SimpleVeinminerClient.getConfig();
        SimpleConfigClient.Highlight outline = config.highlight;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34541);
        RenderSystem.setShaderTexture((int)0, (class_2960)SimpleVeinminer.getId("highlight.png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthFunc((int)519);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_20887);
        class_4184 camera = this.field_4088.field_1773.method_19418();
        this.alpha = Math.max(0.11f, this.alpha);
        boolean b = SimpleVeinminerClient.getConfig().highlight.highlightAllSides;
        for (class_2338 highlight : SimpleVeinminerClient.blocksToHighlight) {
            class_243 targetPosition = new class_243((double)highlight.method_10263(), (double)highlight.method_10264(), (double)highlight.method_10260());
            class_243 transformedPosition = targetPosition.method_1020(camera.method_19326());
            class_4587 matrixStack = new class_4587();
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0f));
            matrixStack.method_22904(transformedPosition.field_1352, transformedPosition.field_1351, transformedPosition.field_1350);
            Matrix4f positionMatrix = matrixStack.method_23760().method_23761();
            class_265 shape = this.field_4085.method_8320(highlight).method_26172((class_1922)this.field_4085, highlight, class_3726.method_16195((class_1297)player));
            switch (outline.mode) {
                case SHAPE: {
                    shape.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
                        class_238 box = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
                        SimpleVeinminerClient.drawBox(buffer, positionMatrix, this.red, this.green, this.blue, this.alpha, box, highlight, SimpleVeinminerClient.blocksToHighlight, b);
                    });
                    break;
                }
                case CUBE: {
                    SimpleVeinminerClient.drawBox(buffer, positionMatrix, this.red, this.green, this.blue, this.alpha, new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), highlight, SimpleVeinminerClient.blocksToHighlight, b);
                    break;
                }
                case CUBE_SHAPE: {
                    SimpleVeinminerClient.drawBox(buffer, positionMatrix, this.red, this.green, this.blue, this.alpha, shape.method_1107(), highlight, SimpleVeinminerClient.blocksToHighlight, b);
                    break;
                }
                case OUTLINE: {
                    SimpleVeinminerClient.drawOutline(buffer, positionMatrix, this.red, this.green, this.blue, this.alpha, shape, highlight, SimpleVeinminerClient.blocksToHighlight, b, matrices);
                }
            }
        }
        tessellator.method_1350();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }

    @Inject(at={@At(value="HEAD")}, method={"drawBlockOutline(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;Lnet/minecraft/entity/Entity;DDDLnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V"}, cancellable=true)
    public void drawBlockOutline(class_4587 matrices, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 pos, class_2680 state, CallbackInfo ci) {
        if (SimpleVeinminerClient.isInstalledOnServerSide.get() && entity.method_31747()) {
            class_1657 player = (class_1657)entity;
            SimpleConfigClient config = SimpleVeinminerClient.getConfig();
            SimpleConfigClient.Highlight outline = config.highlight;
            SimpleConfig.SimpleConfigCopy worldConfig = SimpleVeinminerClient.getWorldConfig();
            int updateRate = SimpleVeinminerClient.getConfig().highlight.updateRate;
            if ((outline.doHighlight || config.hudDisplay.showCount || config.hudDisplay.showBlock) && (SimpleVeinminerClient.veinMineKeybind.method_1434() || SimpleVeinminerClient.isVeinMiningServerSide && player.method_5715()) && SimpleVeinminer.canVeinmine(player, (class_1937)this.field_4085, pos, state, worldConfig.restrictions)) {
                ci.cancel();
                assert (this.field_4088.field_1724 != null);
                class_1792 hand = this.field_4088.field_1724.method_6047().method_7909();
                if (!(SimpleVeinminerClient.previewFrozen || !config.isChanged() && (updateRate <= 0 || this.delay1 % updateRate != 0) && pos.equals((Object)this.currentlyOutliningPos) && state.equals(SimpleVeinminerClient.currentlyOutliningState) && hand.equals(this.holding))) {
                    this.reset();
                    this.holding = hand;
                    Color outlineColor = outline.color;
                    SimpleVeinminerClient.blocksToHighlight = this.getBlocksToOutline(pos, state, player, false);
                    this.currentlyOutliningPos = pos;
                    SimpleVeinminerClient.currentlyOutliningState = state;
                    this.red = (float)outlineColor.getRed() / 255.0f;
                    this.green = (float)outlineColor.getGreen() / 255.0f;
                    this.blue = (float)outlineColor.getBlue() / 255.0f;
                    this.alpha = (float)outline.opacity / 100.0f;
                    this.resetCountdown = true;
                }
                if (outline.doHighlight && outline.mode == SimpleConfigClient.Highlight.MODES.OUTLINE) {
                    for (class_2338 currentPos : SimpleVeinminerClient.blocksToHighlight) {
                        this.outline(matrices, vertexConsumer, entity, d, e, f, currentPos, this.field_4085.method_8320(currentPos), this.red, this.green, this.blue, this.alpha);
                    }
                }
                ++this.delay1;
            } else if (!SimpleVeinminerClient.previewFrozen && this.currentlyOutliningPos != null) {
                this.reset();
            }
        }
    }

    @Unique
    private void reset() {
        this.clearBlockBreakingProgressions();
        this.currentlyOutliningPos = null;
        SimpleVeinminerClient.currentlyOutliningState = null;
        SimpleVeinminerClient.blocksToHighlight = null;
        this.holding = null;
        this.delay1 = 0;
        this.delay2 = 0;
        this.resetCountdown = false;
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/client/render/WorldRenderer;render(Lnet/minecraft/client/util/math/MatrixStack;FJZLnet/minecraft/client/render/Camera;Lnet/minecraft/client/render/GameRenderer;Lnet/minecraft/client/render/LightmapTextureManager;Lorg/joml/Matrix4f;)V"})
    public void renderInject(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci) {
        SortedSet blockBreakingSet;
        class_746 player = this.field_4088.field_1724;
        SimpleConfigClient config = SimpleVeinminerClient.getConfig();
        if (player == null || this.field_4085 == null) {
            return;
        }
        if (!SimpleVeinminerClient.previewFrozen && this.resetCountdown && config.highlight.updateRate > 0 && ++this.delay2 % config.highlight.updateRate == 0) {
            if (this.field_4085.method_8320(SimpleVeinminer.getBlockHitResult((class_1657)this.field_4088.field_1724).method_17777()).method_26215()) {
                this.reset();
                return;
            }
            this.delay2 = 0;
        }
        this.clearBlockBreakingProgressions();
        if (SimpleVeinminerClient.blocksToHighlight != null && this.currentlyOutliningPos != null && SimpleVeinminerClient.veinMining && config.showMiningProgress && (blockBreakingSet = (SortedSet)this.field_20950.get(this.currentlyOutliningPos.method_10063())) != null) {
            class_3191 blockBreakingProgress = (class_3191)blockBreakingSet.last();
            int stage = blockBreakingProgress.method_13988();
            if (this.beingBroken == null) {
                this.beingBroken = (ArrayList)SimpleVeinminerClient.blocksToHighlight.clone();
            }
            for (int i = 0; i < SimpleVeinminerClient.blocksToHighlight.size(); ++i) {
                class_2338 currentPos = SimpleVeinminerClient.blocksToHighlight.get(i);
                if (currentPos.equals((Object)this.currentlyOutliningPos)) continue;
                class_3191 newBlockBreakingProgress = new class_3191(blockBreakingProgress.hashCode(), currentPos);
                newBlockBreakingProgress.method_13987(stage);
                ((SortedSet)this.field_20950.computeIfAbsent(currentPos.method_10063(), l -> Sets.newTreeSet())).add(newBlockBreakingProgress);
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"Lnet/minecraft/client/render/WorldRenderer;render(Lnet/minecraft/client/util/math/MatrixStack;FJZLnet/minecraft/client/render/Camera;Lnet/minecraft/client/render/GameRenderer;Lnet/minecraft/client/render/LightmapTextureManager;Lorg/joml/Matrix4f;)V"})
    public void renderInjectTail(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci) {
        SimpleConfigClient config = SimpleVeinminerClient.getConfig();
        if (SimpleVeinminerClient.blocksToHighlight != null && config.highlight.doHighlight) {
            class_239 hitResult = this.field_4088.field_1765;
            if (!(SimpleVeinminerClient.previewFrozen || hitResult != null && hitResult.method_17783() == class_239.class_240.field_1332)) {
                this.reset();
            } else if (config.highlight.mode != SimpleConfigClient.Highlight.MODES.OUTLINE) {
                this.renderPreview((class_1657)this.field_4088.field_1724, matrices);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/client/render/WorldRenderer;removeBlockBreakingInfo(Lnet/minecraft/client/render/BlockBreakingInfo;)V"}, cancellable=true)
    public void removeBlockBreakingInfoReplace(class_3191 info, CallbackInfo ci) {
        ci.cancel();
        long l = info.method_13991().method_10063();
        Set set = (Set)this.field_20950.get(l);
        if (set != null) {
            set.remove(info);
            if (set.isEmpty()) {
                this.field_20950.remove(l);
            }
        }
    }

    private void clearBlockBreakingProgressions() {
        if (this.beingBroken != null && this.field_20950 != null) {
            for (int i = 0; i < this.beingBroken.size(); ++i) {
                long l;
                SortedSet set;
                class_2338 pos = this.beingBroken.get(i);
                if (pos.equals((Object)this.currentlyOutliningPos) || (set = (SortedSet)this.field_20950.get(l = pos.method_10063())) == null) continue;
                class_3191 info = (class_3191)set.last();
                this.method_22987(info);
            }
        }
        this.beingBroken = null;
    }

    private ArrayList<class_2338> getBlocksToOutline(class_2338 pos, class_2680 state, class_1657 player, boolean onlyExposed) {
        ArrayList<class_2338> willVeinmine = SimpleVeinminer.getBlocksToVeinmine(pos, state, SimpleVeinminer.getMaxBlocks(this.holding), SimpleVeinminer.getVeinminingRadius(player), SimpleVeinminer.getSpreadAccuracy(), player, SimpleVeinminer.isDebug(), SimpleVeinminerClient.getConfig().restrictions.onlyBreakBottomBlockForChainReactions);
        if (!onlyExposed) {
            return willVeinmine;
        }
        ArrayList<class_2338> willOutline = new ArrayList<class_2338>();
        for (int i = 0; i < willVeinmine.size(); ++i) {
            class_2338 currentPos = willVeinmine.get(i);
            if (!this.hasFaceVisible(currentPos)) continue;
            willOutline.add(currentPos);
        }
        return willOutline;
    }

    private boolean hasFaceVisible(class_2338 pos) {
        class_2338[] neighbors;
        if (this.field_4085 == null) {
            return false;
        }
        for (class_2338 neighbor : neighbors = SimpleVeinminer.getNeighbors(pos)) {
            if (this.field_4085.method_8320(neighbor).method_26212((class_1922)this.field_4085, pos)) continue;
            return true;
        }
        return false;
    }

    private void outline(class_4587 matrices, class_4588 vertexConsumer, class_1297 entity, double d, double e, double f, class_2338 pos, class_2680 state, float r, float g, float b, float a) {
        WorldRendererMixin.method_3291(matrices, vertexConsumer, state.method_26172((class_1922)this.field_4085, pos, class_3726.method_16195((class_1297)entity)), (double)pos.method_10263() - d, (double)pos.method_10264() - e, (double)pos.method_10260() - f, r, g, b, a);
    }
}

