/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.client.renderer;

import biomesoplenty.entity.BoatBOP;
import biomesoplenty.entity.ChestBoatBOP;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Quaternionf;

public class BoatRendererBOP
extends class_897<class_1690> {
    private final Map<BoatBOP.ModelType, Pair<class_2960, class_4595<class_1690>>> boatResources;

    public BoatRendererBOP(class_5617.class_5618 context, boolean hasChest) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(BoatBOP.ModelType.values()).collect(ImmutableMap.toImmutableMap(key -> key, model -> Pair.of((Object)new class_2960("biomesoplenty", BoatRendererBOP.getTextureLocation(model, hasChest)), (Object)this.createBoatModel(context, (BoatBOP.ModelType)((Object)model), hasChest))));
    }

    public void render(class_1690 boat, float yaw, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        float f2;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.375f, 0.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
        float f = (float)boat.method_54295() - partialTicks;
        float f1 = boat.method_54294() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)f) * f * f1 / 10.0f * (float)boat.method_54296()));
        }
        if (!class_3532.method_15347((float)(f2 = boat.method_7547(partialTicks)), (float)0.0f)) {
            poseStack.method_22907(new Quaternionf().setAngleAxis(boat.method_7547(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_4595<class_1690>> pair = this.getModelWithLocation(boat);
        class_2960 resourcelocation = (class_2960)pair.getFirst();
        class_4595 listmodel = (class_4595)pair.getSecond();
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        listmodel.method_2819((class_1297)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexconsumer = bufferSource.getBuffer(listmodel.method_23500(resourcelocation));
        listmodel.method_2828(poseStack, vertexconsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.method_5869()) {
            class_4588 vertexconsumer1 = bufferSource.getBuffer(class_1921.method_23589());
            if (listmodel instanceof class_7755) {
                class_7755 waterpatchmodel = (class_7755)listmodel;
                waterpatchmodel.method_22954().method_22698(poseStack, vertexconsumer1, packedLight, class_4608.field_21444);
            }
        }
        poseStack.method_22909();
        super.method_3936((class_1297)boat, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    public class_2960 getTextureLocation(class_1690 boat) {
        return (class_2960)this.getModelWithLocation(boat).getFirst();
    }

    public Pair<class_2960, class_4595<class_1690>> getModelWithLocation(class_1690 boat) {
        if (boat instanceof ChestBoatBOP) {
            return this.boatResources.get((Object)((ChestBoatBOP)boat).getModel());
        }
        return this.boatResources.get((Object)((BoatBOP)boat).getModel());
    }

    private static String getTextureLocation(BoatBOP.ModelType model, boolean hasChest) {
        return hasChest ? "textures/entity/chest_boat/" + model.getName() + ".png" : "textures/entity/boat/" + model.getName() + ".png";
    }

    private static class_5601 createLocation(String name, String layer) {
        return new class_5601(new class_2960("biomesoplenty", name), layer);
    }

    public static class_5601 createBoatModelName(BoatBOP.ModelType model) {
        return BoatRendererBOP.createLocation("boat/" + model.getName(), "main");
    }

    public static class_5601 createChestBoatModelName(BoatBOP.ModelType model) {
        return BoatRendererBOP.createLocation("chest_boat/" + model.getName(), "main");
    }

    private class_554 createBoatModel(class_5617.class_5618 context, BoatBOP.ModelType model, boolean hasChest) {
        class_5601 modellayerlocation = hasChest ? BoatRendererBOP.createChestBoatModelName(model) : BoatRendererBOP.createBoatModelName(model);
        class_630 baked = context.method_32167(modellayerlocation);
        return hasChest ? new class_7752(baked) : new class_554(baked);
    }
}

