/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.SinglePoolElementAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureCondition;
import com.yungnickyoung.minecraft.yungsapi.world.structure.condition.StructureConditionType;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.PieceEntry;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawSinglePoolElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3781;
import net.minecraft.class_3790;

public class PieceInHorizontalDirectionCondition
extends StructureCondition {
    private static final class_2960 ALL = new class_2960("yungsapi", "all");
    public static final Codec<PieceInHorizontalDirectionCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_2960.field_25139.listOf().optionalFieldOf("pieces", new ArrayList()).forGetter(conditon -> conditon.matchPieces), (App)Codec.INT.fieldOf("range").forGetter(conditon -> conditon.range), (App)class_2470.field_39313.fieldOf("rotation").forGetter(conditon -> conditon.rotation)).apply((Applicative)builder, PieceInHorizontalDirectionCondition::new));
    private final List<class_2960> matchPieces;
    private final Integer range;
    private final class_2470 rotation;

    public PieceInHorizontalDirectionCondition(List<class_2960> pieces, int range, class_2470 rotation) {
        this.matchPieces = pieces;
        this.range = range;
        this.rotation = rotation;
        if (this.matchPieces.isEmpty()) {
            this.matchPieces.add(ALL);
        }
    }

    @Override
    public StructureConditionType<?> type() {
        return StructureConditionType.PIECE_IN_HORIZONTAL_DIRECTION;
    }

    @Override
    public boolean passes(StructureContext ctx) {
        class_3485 templateManager = ctx.structureTemplateManager();
        List<PieceEntry> pieces = ctx.pieces();
        class_2470 pieceRotation = ctx.rotation();
        PieceEntry pieceEntry = ctx.pieceEntry();
        if (templateManager == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'structureTemplateManager' for piece_in_horizontal_direction condition!");
        }
        if (pieces == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieces' for piece_in_horizontal_direction condition!");
        }
        if (this.rotation == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'rotation' for piece_in_horizontal_direction condition!");
        }
        if (pieceEntry == null) {
            YungsApiCommon.LOGGER.error("Missing required field 'pieceEntry' for piece_in_horizontal_direction condition!");
        }
        if (templateManager == null || pieces == null || this.rotation == null || pieceEntry == null) {
            return false;
        }
        class_3790 piece = pieceEntry.getPiece();
        class_2470 searchRotation = pieceRotation.method_10501(this.rotation);
        int negX = 0;
        int negZ = 0;
        int posX = 0;
        int posZ = 0;
        switch (searchRotation) {
            case field_11467: {
                negZ = this.range;
                break;
            }
            case field_11463: {
                posX = this.range;
                break;
            }
            case field_11464: {
                posZ = this.range;
                break;
            }
            case field_11465: {
                negX = this.range;
            }
        }
        class_3341 searchBox = new class_3341(piece.method_14935().method_35415() - negX, piece.method_14935().method_35416(), piece.method_14935().method_35417() - negZ, piece.method_14935().method_35418() + posX, piece.method_14935().method_35419(), piece.method_14935().method_35420() + posZ);
        for (PieceEntry otherPieceEntry : pieces) {
            class_3790 otherPiece = otherPieceEntry.getPiece();
            if (!(otherPiece.method_16644() instanceof class_3781) && !(otherPiece.method_16644() instanceof YungJigsawSinglePoolElement) || otherPiece.method_14935().equals((Object)piece.method_14935())) continue;
            class_3499 otherStructureTemplate = otherPiece.method_16644() instanceof class_3781 ? ((SinglePoolElementAccessor)otherPiece.method_16644()).callGetTemplate(templateManager) : ((YungJigsawSinglePoolElement)otherPiece.method_16644()).getTemplate(templateManager);
            for (class_2960 matchPieceId : this.matchPieces) {
                class_3499 structureTemplate = templateManager.method_15091(matchPieceId);
                if (otherStructureTemplate != structureTemplate && !matchPieceId.equals((Object)ALL) || !otherPiece.method_14935().method_14657(searchBox) || otherPiece.method_14935().method_14657(piece.method_14935())) continue;
                return true;
            }
        }
        return false;
    }
}

