/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2960;
import net.pitan76.easyapi.config.Config;
import net.pitan76.easyapi.config.JsonConfig;
import net.pitan76.mcpitanlib.api.registry.CompatRegistry;
import net.pitan76.mcpitanlib.api.util.PlatformUtil;
import net.pitan76.mcpitanlib.debug.DebugTool;

public class MCPitanLib {
    public static final String MOD_ID = "mcpitanlib";
    private static final File configFile = new File(PlatformUtil.getConfigFolder().toFile(), "mcpitanlib/blacklist.json");
    private static final File oldConfigFile = new File(PlatformUtil.getConfigFolder().toFile(), "mcpitanlibarch/blacklist.json");
    public static Config config = new JsonConfig();
    private static boolean configLoaded = false;
    public static List<String> itemBlackList = new ArrayList<String>();
    public static List<String> blockBlackList = new ArrayList<String>();
    public static CompatRegistry registry = CompatRegistry.createRegistry("mcpitanlib");

    public static void init() {
        MCPitanLib.configInit();
        if (PlatformUtil.isDevelopmentEnvironment() || config.has("debugMode") && config.getBoolean("debugMode")) {
            System.out.println("MCPitanLib: Debug Mode");
            DebugTool.register();
            registry.allRegister();
        }
    }

    public static void configInit() {
        if (oldConfigFile.exists() && !configFile.exists()) {
            oldConfigFile.renameTo(configFile);
        }
        try {
            if (configLoaded) {
                return;
            }
            configLoaded = true;
            if (!configFile.getParentFile().exists() && !configFile.getParentFile().mkdirs()) {
                return;
            }
            config.setString("item", "examplemod:hogehoge_item,examplemod:fuga_item");
            config.setString("block", "examplemod:hogehoge_block,examplemod:fuga_block");
            config.setBoolean("debugMode", false);
            if (configFile.exists()) {
                config.load(configFile);
            }
            if (!config.has("debugMode")) {
                config.setBoolean("debugMode", false);
            }
            if (config.has("item")) {
                itemBlackList.addAll(Arrays.asList(config.getString("item").split(",")));
            }
            if (config.has("block")) {
                blockBlackList.addAll(Arrays.asList(config.getString("block").split(",")));
            }
            config.save(configFile);
        }
        catch (Exception e) {
            System.out.println("MCPitanLib: Cannot save config file");
        }
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static boolean isItemBlackListed(class_2960 id) {
        try {
            return itemBlackList.contains(id.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isBlockBlackListed(class_2960 id) {
        try {
            return blockBlackList.contains(id.toString());
        }
        catch (Exception e) {
            return false;
        }
    }
}

