/*
 * Decompiled with CFR 0.152.
 */
package net.pitan76.mcpitanlib.api.util;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.pitan76.mcpitanlib.api.entity.Player;
import org.jetbrains.annotations.Nullable;

public class WorldUtil {
    public static boolean hasSkyLight(class_1937 world) {
        return world.method_8597().comp_642();
    }

    public static boolean isThundering(class_1937 world) {
        return world.method_8546();
    }

    public static boolean isRaining(class_1937 world) {
        return world.method_8419();
    }

    public static boolean isNight(class_1937 world) {
        return world.method_23886();
    }

    public static boolean isDay(class_1937 world) {
        return world.method_8530();
    }

    public static boolean isSkyVisible(class_1937 world, class_2338 pos) {
        return world.method_8311(pos);
    }

    public static boolean isClient(class_1937 world) {
        return world.method_8608();
    }

    public static void scheduleBlockTick(class_1937 world, class_2338 pos, class_2248 block, int delay) {
        world.method_39279(pos, block, delay);
    }

    public static void scheduleFluidTick(class_1937 world, class_2338 pos, class_3611 fluid, int delay) {
        world.method_39281(pos, fluid, delay);
    }

    public static boolean isServer(class_1937 world) {
        return !WorldUtil.isClient(world);
    }

    public static void spawnStack(class_1937 world, class_2338 pos, class_1799 stack) {
        WorldUtil.spawnEntity(world, (class_1297)new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack));
    }

    public static void spawnExperienceOrb(class_1937 world, class_243 pos, int amount) {
        if (world instanceof class_3218) {
            class_1303.method_31493((class_3218)((class_3218)world), (class_243)pos, (int)amount);
        }
    }

    public static void spawnExperienceOrb(class_1937 world, class_2338 pos, int amount) {
        WorldUtil.spawnExperienceOrb(world, pos.method_46558(), amount);
    }

    public static void spawnEntity(class_1937 world, class_1297 entity) {
        world.method_8649(entity);
    }

    public static void playSound(class_1937 world, @Nullable Player player, class_2338 pos, class_3414 sound, class_3419 category, float volume, float pitch) {
        class_1657 entity = player == null ? null : player.getEntity();
        world.method_8396(entity, pos, sound, category, volume, pitch);
    }

    public static void sendEntityStatus(class_1937 world, class_1297 entity, byte status) {
        world.method_8421(entity, status);
    }

    public static class_2338 getSpawnPos(class_1937 world) {
        return world.method_43126();
    }

    public static class_1937 getWorld(class_1937 world, class_2960 worldId) {
        if (WorldUtil.isClient(world)) {
            return null;
        }
        return WorldUtil.getWorld(world.method_8503(), worldId);
    }

    public static class_1937 getOverworld(MinecraftServer server) {
        return server.method_3847(class_1937.field_25179);
    }

    public static class_1937 getNether(MinecraftServer server) {
        return server.method_3847(class_1937.field_25180);
    }

    public static class_1937 getEnd(MinecraftServer server) {
        return server.method_3847(class_1937.field_25181);
    }

    public static class_1937 getWorld(MinecraftServer server, class_2960 worldId) {
        return server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)worldId));
    }

    public static class_2960 getWorldId(class_1937 world) {
        return world.method_27983().method_29177();
    }

    public static boolean equals(class_1937 world, class_1937 world2) {
        return Objects.equals(WorldUtil.getWorldId(world), WorldUtil.getWorldId(world2));
    }

    public static <T> void addTicket(class_3218 world, class_3230<T> type, class_1923 pos, int radius, T argument) {
        world.method_14178().method_17297(type, pos, radius, argument);
    }

    public static <T> void removeTicket(class_3218 world, class_3230<T> type, class_1923 pos, int radius, T argument) {
        world.method_14178().method_17300(type, pos, radius, argument);
    }

    public static boolean isReceivingRedstonePower(class_1937 world, class_2338 pos) {
        return world.method_49803(pos);
    }

    public static int getBottomY(class_1937 world) {
        return world.method_31607();
    }

    public static int getTopY(class_1937 world) {
        return world.method_31600();
    }

    public static int getDimensionHeight(class_1937 world) {
        return world.method_8597().comp_652();
    }

    public static class_2586 getBlockEntity(class_1937 world, class_2338 pos) {
        return world.method_8321(pos);
    }

    public static boolean hasBlockEntity(class_1937 world, class_2338 pos) {
        return WorldUtil.getBlockEntity(world, pos) != null;
    }

    public static class_2680 getBlockState(class_1937 world, class_2338 pos) {
        return world.method_8320(pos);
    }

    public static class_3610 getFluidState(class_1937 world, class_2338 pos) {
        return world.method_8316(pos);
    }

    public static boolean hasFluidState(class_1937 world, class_2338 pos) {
        return !WorldUtil.getFluidState(world, pos).method_15769();
    }

    public static boolean isAir(class_1937 world, class_2338 pos) {
        return WorldUtil.getBlockState(world, pos).method_26215();
    }

    public static void setBlockState(class_1937 world, class_2338 pos, class_2680 state, int flags) {
        world.method_8652(pos, state, flags);
    }

    public static void setBlockState(class_1937 world, class_2338 pos, class_2680 state) {
        WorldUtil.setBlockState(world, pos, state, 3);
    }

    public static void setBlockState(class_1937 world, class_2338 pos, class_2248 block, int flags) {
        WorldUtil.setBlockState(world, pos, block.method_9564(), flags);
    }

    public static void setBlockState(class_1937 world, class_2338 pos, class_2248 block) {
        WorldUtil.setBlockState(world, pos, block, 3);
    }

    public static boolean breakBlock(class_1937 world, class_2338 pos, boolean drop) {
        return world.method_22352(pos, drop);
    }

    public static boolean breakBlock(class_1937 world, class_2338 pos) {
        return WorldUtil.breakBlock(world, pos, true);
    }

    public static boolean breakBlock(class_1937 world, class_2338 pos, boolean drop, @Nullable Player player) {
        return world.method_8651(pos, drop, (class_1297)player.getPlayerEntity());
    }

    public static boolean breakBlock(class_1937 world, class_2338 pos, @Nullable Player player) {
        return WorldUtil.breakBlock(world, pos, true, player);
    }

    public static void removeBlockEntity(class_1937 world, class_2338 pos) {
        world.method_8544(pos);
    }

    public static boolean removeBlock(class_1937 world, class_2338 pos, boolean move) {
        return world.method_8650(pos, move);
    }
}

