/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import glitchcore.event.client.ItemTooltipEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;

public class ModFertility {
    private static Set<String> springPlants = new HashSet<String>();
    private static Set<String> summerPlants = new HashSet<String>();
    private static Set<String> autumnPlants = new HashSet<String>();
    private static Set<String> winterPlants = new HashSet<String>();
    private static Set<String> allListedPlants = new HashSet<String>();
    private static HashMap<String, Integer> seedSeasons = new HashMap();

    public static void populate() {
        springPlants.clear();
        summerPlants.clear();
        autumnPlants.clear();
        winterPlants.clear();
        allListedPlants.clear();
        seedSeasons.clear();
        ModFertility.populateSeasonCrops(ModTags.Blocks.SPRING_CROPS, springPlants, 1);
        ModFertility.populateSeasonCrops(ModTags.Blocks.SUMMER_CROPS, summerPlants, 2);
        ModFertility.populateSeasonCrops(ModTags.Blocks.AUTUMN_CROPS, autumnPlants, 4);
        ModFertility.populateSeasonCrops(ModTags.Blocks.WINTER_CROPS, winterPlants, 8);
        ModFertility.populateSeasonSeeds(ModTags.Items.SPRING_CROPS, springPlants, 1);
        ModFertility.populateSeasonSeeds(ModTags.Items.SUMMER_CROPS, summerPlants, 2);
        ModFertility.populateSeasonSeeds(ModTags.Items.AUTUMN_CROPS, autumnPlants, 4);
        ModFertility.populateSeasonSeeds(ModTags.Items.WINTER_CROPS, winterPlants, 8);
    }

    public static boolean isCrop(class_2680 state) {
        return state.method_26164(ModTags.Blocks.SPRING_CROPS) || state.method_26164(ModTags.Blocks.SUMMER_CROPS) || state.method_26164(ModTags.Blocks.AUTUMN_CROPS) || state.method_26164(ModTags.Blocks.WINTER_CROPS);
    }

    public static boolean isCropFertile(String cropName, class_1937 level, class_2338 pos) {
        Season season = SeasonHelper.getSeasonState(level).getSeason();
        class_6880 biome = level.method_23753(pos);
        if (pos.method_10264() < ModConfig.fertility.undergroundFertilityLevel && !level.method_8311(pos)) {
            return true;
        }
        if (biome.method_40220(ModTags.Biomes.INFERTILE_BIOMES)) {
            return false;
        }
        if (!ModConfig.fertility.seasonalCrops || biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES) || !ModConfig.seasons.isDimensionWhitelisted((class_5321<class_1937>)level.method_27983())) {
            return true;
        }
        if (biome.method_40220(ModTags.Biomes.TROPICAL_BIOMES)) {
            return summerPlants.contains(cropName) || !allListedPlants.contains(cropName);
        }
        if (!((class_1959)biome.comp_349()).method_39927(pos)) {
            return winterPlants.contains(cropName);
        }
        if (season == Season.SPRING && springPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.SUMMER && summerPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.AUTUMN && autumnPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.WINTER && winterPlants.contains(cropName)) {
            return true;
        }
        return !allListedPlants.contains(cropName);
    }

    private static void populateSeasonCrops(class_6862<class_2248> tag, Set<String> cropSet, int bitmask) {
        class_7923.field_41175.method_40266(tag).ifPresent(blocks -> {
            for (class_6880 block : blocks) {
                Optional blockKey = block.method_40230();
                if (blockKey.isEmpty()) continue;
                String plantName = ((class_5321)blockKey.get()).method_29177().toString();
                cropSet.add(plantName);
                if (bitmask == 0) continue;
                allListedPlants.add(plantName);
                if (seedSeasons.containsKey(plantName)) {
                    int seasons = seedSeasons.get(plantName);
                    seedSeasons.put(plantName, seasons | bitmask);
                    continue;
                }
                seedSeasons.put(plantName, bitmask);
            }
        });
    }

    private static void populateSeasonSeeds(class_6862<class_1792> tag, Set<String> cropSet, int bitmask) {
        class_7923.field_41178.method_40266(tag).ifPresent(items -> {
            for (class_6880 item : items) {
                Optional itemKey = item.method_40230();
                if (itemKey.isEmpty()) continue;
                String plantName = ((class_5321)itemKey.get()).method_29177().toString();
                cropSet.add(plantName);
                if (bitmask == 0) continue;
                allListedPlants.add(plantName);
                if (seedSeasons.containsKey(plantName)) {
                    int seasons = seedSeasons.get(plantName);
                    seedSeasons.put(plantName, seasons | bitmask);
                    continue;
                }
                seedSeasons.put(plantName, bitmask);
            }
        });
    }

    public static void setupTooltips(ItemTooltipEvent event) {
        String name;
        if (ModConfig.fertility.cropTooltips && ModConfig.fertility.seasonalCrops && seedSeasons.containsKey(name = class_7923.field_41178.method_10221((Object)event.getStack().method_7909()).toString())) {
            int mask = seedSeasons.get(name);
            event.getTooltip().add(class_2561.method_43471((String)"desc.sereneseasons.fertile_seasons").method_27693(":"));
            if ((mask & 1) != 0 && (mask & 2) != 0 && (mask & 4) != 0 && (mask & 8) != 0) {
                event.getTooltip().add(class_2561.method_43471((String)" ").method_10852((class_2561)class_2561.method_43471((String)"desc.sereneseasons.year_round")).method_27692(class_124.field_1076));
            } else {
                if ((mask & 1) != 0) {
                    event.getTooltip().add(class_2561.method_43471((String)" ").method_10852((class_2561)class_2561.method_43471((String)"desc.sereneseasons.spring")).method_27692(class_124.field_1060));
                }
                if ((mask & 2) != 0) {
                    event.getTooltip().add(class_2561.method_43471((String)" ").method_10852((class_2561)class_2561.method_43471((String)"desc.sereneseasons.summer")).method_27692(class_124.field_1054));
                }
                if ((mask & 4) != 0) {
                    event.getTooltip().add(class_2561.method_43471((String)" ").method_10852((class_2561)class_2561.method_43471((String)"desc.sereneseasons.autumn")).method_27692(class_124.field_1065));
                }
                if ((mask & 8) != 0) {
                    event.getTooltip().add(class_2561.method_43471((String)" ").method_10852((class_2561)class_2561.method_43471((String)"desc.sereneseasons.winter")).method_27692(class_124.field_1075));
                }
            }
        }
    }
}

