/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.neoforge.networking;

import com.natamus.collective.neoforge.networking.NeoForgePacket;
import com.natamus.collective.neoforge.networking.NeoForgePacketContainer;
import com.natamus.collective_common_neoforge.data.Constants;
import com.natamus.collective_common_neoforge.implementations.networking.PacketRegistrationHandler;
import com.natamus.collective_common_neoforge.implementations.networking.data.PacketContainer;
import com.natamus.collective_common_neoforge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_neoforge.implementations.networking.data.Side;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class NeoForgeNetworkHandler
extends PacketRegistrationHandler {
    private final Map<Class<?>, NeoForgePacketContainer> PACKETS = new HashMap();

    public NeoForgeNetworkHandler(Side side) {
        super(side);
    }

    @SubscribeEvent
    public void register(RegisterPayloadHandlerEvent event) {
        if (!this.PACKETS.isEmpty()) {
            this.PACKETS.forEach((type, container) -> {
                IPayloadRegistrar registrar = event.registrar(container.packetIdentifier().getNamespace());
                registrar.common(container.packetIdentifier(), container.decoder(), container.handler());
            });
        }
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
        if (this.PACKETS.get(container.messageType()) == null) {
            NeoForgePacketContainer<T> packetContainer = new NeoForgePacketContainer<T>(container.messageType(), container.packetIdentifier(), container.encoder(), this.decoder(container.decoder()), this.buildHandler(container.handler()));
            this.PACKETS.put(container.messageType(), packetContainer);
        }
    }

    private <T> FriendlyByteBuf.Reader<NeoForgePacket<T>> decoder(Function<FriendlyByteBuf, T> decoder) {
        return buf -> {
            Object packet = decoder.apply((FriendlyByteBuf)buf);
            return new NeoForgePacket(this.PACKETS.get(packet.getClass()), packet);
        };
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        NeoForgePacketContainer container = this.PACKETS.get(packet.getClass());
        try {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new NeoForgePacket<T>(container, packet)});
        }
        catch (Throwable t) {
            Constants.LOG.error("{} packet not registered on the client, this is needed.", packet.getClass(), (Object)t);
        }
    }

    @Override
    public <T> void sendToClient(T packet, ServerPlayer player) {
        NeoForgePacketContainer container = this.PACKETS.get(packet.getClass());
        try {
            if (player.connection.isConnected(container.packetIdentifier())) {
                PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new NeoForgePacket<T>(container, packet)});
            }
        }
        catch (Throwable t) {
            Constants.LOG.error("{} packet not registered on the server, this is needed.", packet.getClass(), (Object)t);
        }
    }

    private <T, K extends NeoForgePacket<T>> IPayloadHandler<K> buildHandler(Consumer<PacketContext<T>> handler) {
        return (payload, ctx) -> {
            try {
                Side side = ctx.flow().getReceptionSide().equals((Object)LogicalSide.SERVER) ? Side.SERVER : Side.CLIENT;
                Player player = ctx.player().orElse(null);
                handler.accept(new PacketContext(player, payload.packet(), side));
            }
            catch (Throwable t) {
                Constants.LOG.error("Error handling packet: {} -> ", payload.packet().getClass(), (Object)t);
            }
        };
    }
}

