/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.radio.audio;

import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import earth.terrarium.adastra.common.utils.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_7367;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public class RadioStream
extends InputStream {
    private static final int SIZE = 8;
    private static final int KB = 1024;
    private static final int BUFFER_SIZE = 8192;
    private final Deque<ByteBuffer> cache = new LinkedList<ByteBuffer>();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean waiting = new AtomicBoolean(false);
    private final CompletableFuture<?> getter;
    private ByteBuffer data;

    public RadioStream(class_7367<InputStream> inputStream) {
        AtomicBoolean setup = new AtomicBoolean(true);
        this.getter = CompletableFuture.runAsync(() -> {
            try (InputStream stream2 = (InputStream)inputStream.get();){
                while (!this.closed.get()) {
                    ByteBuffer buffer = ByteBuffer.allocate(8192);
                    IOUtils.read((ReadableByteChannel)Channels.newChannel(stream2), (ByteBuffer)buffer);
                    buffer.flip();
                    if (this.closed.get()) {
                        break;
                    }
                    if (buffer.hasRemaining()) {
                        this.wait(this.waiting);
                        this.cache.add(buffer);
                        if (this.cache.size() > 8) {
                            this.waiting.set(true);
                        }
                    }
                    if (this.cache.size() < 8) continue;
                    setup.set(false);
                }
            }
            catch (ClosedException stream2) {
            }
            catch (IOException e) {
                setup.set(false);
                throw new CompletionException(e);
            }
            setup.set(false);
        }, (Executor)RadioHandler.DOWNLOAD_EXECUTOR);
        try {
            this.wait(setup);
        }
        catch (ClosedException closedException) {
            // empty catch block
        }
    }

    private boolean next() {
        if (this.waiting.get() && this.cache.size() < 8) {
            this.waiting.set(false);
        }
        this.data = this.cache.poll();
        return this.data == null || this.cache.isEmpty();
    }

    @Override
    public int read() {
        return this.isNotReadable() ? -1 : (int)this.data.get();
    }

    @Override
    public int read(byte @NotNull [] bytes, int offset, int length) {
        int count;
        if (this.isNotReadable()) {
            return -1;
        }
        for (count = 0; count < length && !this.isNotReadable(); count += BufferUtils.read(this.data, bytes, offset + count, length, count)) {
        }
        return count;
    }

    @Override
    public long skip(long length) {
        if (this.isNotReadable()) {
            return 0L;
        }
        int count = 0;
        while ((long)count < length && !this.isNotReadable()) {
            count += BufferUtils.skip(this.data, (int)length, count);
        }
        return count;
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.getter.join();
    }

    public boolean isNotReadable() {
        return (this.data == null || !this.data.hasRemaining()) && this.next();
    }

    private void wait(AtomicBoolean waiting) {
        while (!this.closed.get() && waiting.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }
        if (!this.closed.get()) {
            return;
        }
        throw new ClosedException();
    }

    private static class ClosedException
    extends RuntimeException {
        private ClosedException() {
            super("Stream closed");
        }
    }
}

