/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.container;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.impl.ExtractOnlyFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.InsertOnlyFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public record BiFluidContainer(SimpleFluidContainer input, SimpleFluidContainer output) implements FluidContainer
{
    public BiFluidContainer(long capacity, int inputTanks, int outputTanks, BiPredicate<Integer, FluidHolder> inputFilter, BiPredicate<Integer, FluidHolder> outputFilter) {
        this((SimpleFluidContainer)new InsertOnlyFluidContainer(i -> capacity, inputTanks, inputFilter), (SimpleFluidContainer)new ExtractOnlyFluidContainer(i -> capacity, outputTanks, outputFilter));
    }

    public long insertFluid(FluidHolder fluid, boolean simulate) {
        if (fluid.isEmpty()) {
            return 0L;
        }
        return this.input.insertFluid(fluid, simulate);
    }

    public long internalInsert(FluidHolder fluids, boolean simulate) {
        if (fluids.isEmpty()) {
            return 0L;
        }
        return this.output.internalInsert(fluids, simulate);
    }

    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        if (fluid.isEmpty()) {
            return FluidHolder.empty();
        }
        return this.output.extractFluid(fluid, simulate);
    }

    public FluidHolder internalExtract(FluidHolder fluid, boolean simulate) {
        if (fluid.isEmpty()) {
            return FluidHolder.empty();
        }
        return this.input.internalExtract(fluid, simulate);
    }

    public void setFluid(int slot, FluidHolder fluid) {
    }

    public List<FluidHolder> getFluids() {
        return Stream.concat(this.input.getFluids().stream(), this.output.getFluids().stream()).toList();
    }

    public int getSize() {
        return 2;
    }

    public boolean isEmpty() {
        return this.input.isEmpty() && this.output.isEmpty();
    }

    public FluidContainer copy() {
        return new BiFluidContainer(this.input.copy(), this.output.copy());
    }

    public long getTankCapacity(int tankSlot) {
        return tankSlot == 0 ? this.input.getTankCapacity(0) : this.output.getTankCapacity(0);
    }

    public void fromContainer(FluidContainer container) {
        if (!(container instanceof BiFluidContainer)) {
            return;
        }
        BiFluidContainer tank = (BiFluidContainer)container;
        this.input.fromContainer((FluidContainer)tank.input);
        this.output.fromContainer((FluidContainer)tank.output);
    }

    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        return this.output.extractFromSlot(fluidHolder, toInsert, snapshot);
    }

    public boolean allowsInsertion() {
        return true;
    }

    public boolean allowsExtraction() {
        return true;
    }

    public FluidSnapshot createSnapshot() {
        return new BiFluidSnapshot(this.input.createSnapshot(), this.output.createSnapshot());
    }

    public void deserialize(class_2487 nbt) {
        this.input.deserialize(nbt.method_10562("Input"));
        this.output.deserialize(nbt.method_10562("Output"));
    }

    public class_2487 serialize(class_2487 nbt) {
        nbt.method_10566("Input", (class_2520)this.input.serialize(new class_2487()));
        nbt.method_10566("Output", (class_2520)this.output.serialize(new class_2487()));
        return nbt;
    }

    public void method_5448() {
        this.input.method_5448();
        this.output.method_5448();
    }

    public void readSnapshot(FluidSnapshot snapshot) {
        if (!(snapshot instanceof BiFluidSnapshot)) {
            return;
        }
        BiFluidSnapshot tank = (BiFluidSnapshot)snapshot;
        this.input.readSnapshot(tank.input);
        this.output.readSnapshot(tank.output);
    }

    private record BiFluidSnapshot(FluidSnapshot input, FluidSnapshot output) implements FluidSnapshot
    {
        public void loadSnapshot(FluidContainer container) {
            if (!(container instanceof WrappedBlockFluidContainer)) {
                return;
            }
            WrappedBlockFluidContainer wrapped = (WrappedBlockFluidContainer)container;
            FluidContainer fluidContainer = wrapped.container();
            if (!(fluidContainer instanceof BiFluidContainer)) {
                return;
            }
            BiFluidContainer tank = (BiFluidContainer)fluidContainer;
            this.input.loadSnapshot((FluidContainer)tank.input);
            this.output.loadSnapshot((FluidContainer)tank.output);
        }
    }
}

