/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.handlers;

import com.mojang.serialization.DynamicOps;
import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.common.planets.AdAstraData;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class LaunchingDimensionHandler
extends SaveHandler {
    private final Map<UUID, LaunchedDimensions> data = new HashMap<UUID, LaunchedDimensions>();

    public void loadData(class_2487 tag) {
        tag.method_10541().forEach(key -> {
            UUID uuid = UUID.fromString(key);
            class_2487 planetsTag = tag.method_10562(key);
            HashMap<class_5321<class_1937>, class_4208> planets = new HashMap<class_5321<class_1937>, class_4208>();
            for (String allKey : planetsTag.method_10541()) {
                class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)planetsTag.method_10562(allKey)).result().ifPresent(pos -> {
                    class_2960 planet = class_2960.method_12829((String)allKey);
                    planets.put((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)Objects.requireNonNull(planet)), (class_4208)pos);
                });
            }
            this.data.put(uuid, new LaunchedDimensions(planets));
        });
    }

    public void saveData(class_2487 tag) {
        this.data.forEach((uuid, data) -> {
            class_2487 planetsTag = new class_2487();
            for (Map.Entry<class_5321<class_1937>, class_4208> entry : data.dimensions.entrySet()) {
                class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)entry.getValue()).result().ifPresent(pos -> planetsTag.method_10566(((class_5321)entry.getKey()).method_29177().toString(), pos));
            }
            tag.method_10566(uuid.toString(), (class_2520)planetsTag);
        });
    }

    public static LaunchingDimensionHandler read(class_3218 level) {
        return (LaunchingDimensionHandler)LaunchingDimensionHandler.read((class_1937)level, (SaveHandler.HandlerType)SaveHandler.HandlerType.create(LaunchingDimensionHandler::new), (String)"adastra_launching_dimensions");
    }

    private static LaunchedDimensions get(class_1657 player, class_3218 level, boolean create) {
        Map<UUID, LaunchedDimensions> data = LaunchingDimensionHandler.read((class_3218)level).data;
        if (data.containsKey(player.method_5667())) {
            return data.get(player.method_5667());
        }
        if (create) {
            LaunchedDimensions dimensions = new LaunchedDimensions();
            data.put(player.method_5667(), dimensions);
            return dimensions;
        }
        return null;
    }

    public static Optional<class_4208> getSpawningLocation(class_1657 player, class_3218 level, Planet planet) {
        LaunchedDimensions dimensions = LaunchingDimensionHandler.get(player, level, false);
        if (dimensions == null) {
            return Optional.empty();
        }
        class_4208 pos = dimensions.dimensions.get(planet.dimension());
        if (pos != null) {
            boolean validPlanet;
            boolean bl = validPlanet = planet.additionalLaunchDimensions().contains(pos.method_19442()) || planet.dimension().equals((Object)pos.method_19442());
            if (validPlanet) {
                return Optional.of(pos);
            }
        }
        return Optional.empty();
    }

    public static Collection<class_4208> getAllSpawnLocations(class_3222 player) {
        HashSet<class_4208> positions = new HashSet<class_4208>();
        LaunchedDimensions dimensions = LaunchingDimensionHandler.get((class_1657)player, player.method_51469(), false);
        if (dimensions == null) {
            return positions;
        }
        for (Map.Entry<class_5321<class_1937>, class_4208> entry : dimensions.dimensions.entrySet()) {
            positions.add(entry.getValue());
        }
        return positions;
    }

    public static void addSpawnLocation(class_1657 player, class_3218 level) {
        LaunchedDimensions dimensions = LaunchingDimensionHandler.get(player, level, true);
        if (dimensions == null) {
            return;
        }
        class_5321<class_1937> planet = AdAstraData.getPlanetLocation((class_5321<class_1937>)level.method_27983());
        if (planet == null) {
            return;
        }
        dimensions.dimensions.put(planet, class_4208.method_19443((class_5321)level.method_27983(), (class_2338)player.method_24515()));
    }

    public boolean method_79() {
        return true;
    }

    private record LaunchedDimensions(Map<class_5321<class_1937>, class_4208> dimensions) {
        public LaunchedDimensions() {
            this(new HashMap<class_5321<class_1937>, class_4208>());
        }
    }
}

