/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.network.messages;

import com.teamresourceful.bytecodecs.base.ObjectEntryByteCodec;
import com.teamresourceful.bytecodecs.base.object.ObjectByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import com.teamresourceful.resourcefullib.common.network.defaults.CodecPacketType;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.common.compat.cadmus.CadmusIntegration;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.LaunchingDimensionHandler;
import earth.terrarium.adastra.common.handlers.SpaceStationHandler;
import earth.terrarium.adastra.common.recipes.SpaceStationRecipe;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_8786;

public record ServerboundConstructSpaceStationPacket(class_5321<class_1937> dimension, class_2561 name) implements Packet<ServerboundConstructSpaceStationPacket>
{
    public static final ServerboundPacketType<ServerboundConstructSpaceStationPacket> TYPE = new Type();

    public PacketType<ServerboundConstructSpaceStationPacket> type() {
        return TYPE;
    }

    private static class Type
    extends CodecPacketType<ServerboundConstructSpaceStationPacket>
    implements ServerboundPacketType<ServerboundConstructSpaceStationPacket> {
        public Type() {
            super(ServerboundConstructSpaceStationPacket.class, new class_2960("ad_astra", "construct_space_station"), ObjectByteCodec.create((ObjectEntryByteCodec)ExtraByteCodecs.DIMENSION.fieldOf(ServerboundConstructSpaceStationPacket::dimension), (ObjectEntryByteCodec)ExtraByteCodecs.COMPONENT.fieldOf(ServerboundConstructSpaceStationPacket::name), ServerboundConstructSpaceStationPacket::new));
        }

        public Consumer<class_1657> handle(ServerboundConstructSpaceStationPacket packet) {
            return player -> {
                class_1937 patt3020$temp = player.method_37908();
                if (!(patt3020$temp instanceof class_3218)) {
                    return;
                }
                class_3218 serverLevel = (class_3218)patt3020$temp;
                if (!(player instanceof class_3222)) {
                    return;
                }
                class_3222 serverPlayer = (class_3222)player;
                Planet planet = PlanetApi.API.getPlanet(packet.dimension);
                if (planet == null) {
                    return;
                }
                class_3218 targetLevel = serverLevel.method_8503().method_3847(planet.orbitIfPresent());
                if (targetLevel == null) {
                    return;
                }
                if (!PlanetApi.API.isSpace((class_1937)targetLevel)) {
                    return;
                }
                if (!ModUtils.canTeleportToPlanet(player, planet)) {
                    return;
                }
                if (CadmusIntegration.cadmusLoaded() && CadmusIntegration.isClaimed(targetLevel, player.method_31476())) {
                    return;
                }
                class_8786 recipe = SpaceStationRecipe.getSpaceStation((class_1937)targetLevel, (class_5321<class_1937>)targetLevel.method_27983()).orElse(null);
                if (recipe == null) {
                    return;
                }
                if (SpaceStationHandler.isInSpaceStation(serverPlayer, targetLevel)) {
                    return;
                }
                if (!SpaceStationRecipe.hasIngredients((class_1657)serverPlayer, (class_1937)targetLevel, (SpaceStationRecipe)recipe.comp_1933())) {
                    return;
                }
                SpaceStationRecipe.consumeIngredients((class_1657)serverPlayer, (class_1937)targetLevel);
                class_1923 pos = player.method_31476();
                class_3499 structure = targetLevel.method_14183().method_15091(((SpaceStationRecipe)recipe.comp_1933()).structure());
                class_2338 stationPos = class_2338.method_49637((double)((float)pos.method_33940() - (float)structure.method_15160().method_10263() / 2.0f), (double)100.0, (double)((float)pos.method_33942() - (float)structure.method_15160().method_10260() / 2.0f));
                targetLevel.method_14178().method_17297(class_3230.field_19280, new class_1923(stationPos), 1, (Object)stationPos);
                structure.method_15172((class_5425)targetLevel, stationPos, stationPos, new class_3492(), targetLevel.field_9229, 2);
                SpaceStationHandler.constructSpaceStation(serverPlayer, targetLevel, packet.name);
                LaunchingDimensionHandler.addSpawnLocation(player, serverLevel);
                class_2338 middleBlockPosition = pos.method_33943(AdAstraConfig.atmosphereLeave);
                ModUtils.land(serverPlayer, targetLevel, new class_243((double)((float)middleBlockPosition.method_10263() - 0.5f), (double)middleBlockPosition.method_10264(), (double)((float)middleBlockPosition.method_10260() - 0.5f)));
                if (CadmusIntegration.cadmusLoaded()) {
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            CadmusIntegration.claim(serverPlayer, new class_1923(pos.field_9181 + i, pos.field_9180 + j));
                        }
                    }
                }
            };
        }
    }
}

