/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.world.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import earth.terrarium.adastra.common.registry.ModBlocks;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_5156;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.jetbrains.annotations.Nullable;

public class InfernalSpireColumnFeature
extends class_3031<class_5156> {
    private static final ImmutableList<class_2248> CANNOT_PLACE_ON = ImmutableList.of((Object)class_2246.field_10164, (Object)class_2246.field_9987, (Object)class_2246.field_10092, (Object)class_2246.field_10114, (Object)class_2246.field_10266, (Object)class_2246.field_10364, (Object)class_2246.field_10159, (Object)class_2246.field_9974, (Object)class_2246.field_10034, (Object)class_2246.field_10260);

    public InfernalSpireColumnFeature(Codec<class_5156> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<class_5156> context) {
        int i = context.method_33653().method_16398();
        class_2338 blockPos = context.method_33655();
        class_5281 worldGenLevel = context.method_33652();
        class_5819 randomSource = context.method_33654();
        class_5156 columnFeatureConfiguration = (class_5156)context.method_33656();
        if (!InfernalSpireColumnFeature.canPlaceAt((class_1936)worldGenLevel, i, blockPos.method_25503())) {
            return false;
        }
        int j = columnFeatureConfiguration.method_30394().method_35008(randomSource);
        boolean bl = randomSource.method_43057() < 0.9f;
        int k = Math.min(j, bl ? 5 : 8);
        int l = bl ? 50 : 15;
        boolean bl2 = false;
        for (class_2338 blockPos2 : class_2338.method_27156((class_5819)randomSource, (int)l, (int)(blockPos.method_10263() - k), (int)blockPos.method_10264(), (int)(blockPos.method_10260() - k), (int)(blockPos.method_10263() + k), (int)blockPos.method_10264(), (int)(blockPos.method_10260() + k))) {
            int m = j - blockPos2.method_19455((class_2382)blockPos);
            if (m < 0) continue;
            bl2 |= this.placeColumn((class_1936)worldGenLevel, i, blockPos2, m, columnFeatureConfiguration.method_30391().method_35008(randomSource));
        }
        return bl2;
    }

    private boolean placeColumn(class_1936 level, int seaLevel, class_2338 pos, int distance, int reach) {
        boolean bl = false;
        block0: for (class_2338 blockPos : class_2338.method_10094((int)(pos.method_10263() - reach), (int)pos.method_10264(), (int)(pos.method_10260() - reach), (int)(pos.method_10263() + reach), (int)pos.method_10264(), (int)(pos.method_10260() + reach))) {
            int i = blockPos.method_19455((class_2382)pos);
            class_2338 blockPos2 = InfernalSpireColumnFeature.isAirOrLavaOcean(level, seaLevel, blockPos) ? InfernalSpireColumnFeature.findSurface(level, seaLevel, blockPos.method_25503(), i) : InfernalSpireColumnFeature.findAir(level, blockPos.method_25503(), i);
            if (blockPos2 == null) continue;
            class_2338.class_2339 mutableBlockPos = blockPos2.method_25503();
            for (int j = distance - i / 2; j >= 0; --j) {
                if (InfernalSpireColumnFeature.isAirOrLavaOcean(level, seaLevel, (class_2338)mutableBlockPos)) {
                    this.method_13153((class_1945)level, (class_2338)mutableBlockPos, ((class_2248)ModBlocks.INFERNAL_SPIRE_BLOCK.get()).method_9564());
                    mutableBlockPos.method_10098(class_2350.field_11036);
                    bl = true;
                    continue;
                }
                if (!level.method_8320((class_2338)mutableBlockPos).method_27852((class_2248)ModBlocks.INFERNAL_SPIRE_BLOCK.get())) continue block0;
                mutableBlockPos.method_10098(class_2350.field_11036);
            }
        }
        return bl;
    }

    @Nullable
    private static class_2338 findSurface(class_1936 level, int seaLevel, class_2338.class_2339 pos, int distance) {
        while (pos.method_10264() > level.method_31607() + 1 && distance > 0) {
            --distance;
            if (InfernalSpireColumnFeature.canPlaceAt(level, seaLevel, pos)) {
                return pos;
            }
            pos.method_10098(class_2350.field_11033);
        }
        return null;
    }

    private static boolean canPlaceAt(class_1936 level, int seaLevel, class_2338.class_2339 pos) {
        if (!InfernalSpireColumnFeature.isAirOrLavaOcean(level, seaLevel, (class_2338)pos)) {
            return false;
        }
        class_2680 blockState = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033));
        pos.method_10098(class_2350.field_11036);
        return !blockState.method_26215() && !CANNOT_PLACE_ON.contains((Object)blockState.method_26204());
    }

    @Nullable
    private static class_2338 findAir(class_1936 level, class_2338.class_2339 pos, int distance) {
        while (pos.method_10264() < level.method_31600() && distance > 0) {
            --distance;
            class_2680 blockState = level.method_8320((class_2338)pos);
            if (CANNOT_PLACE_ON.contains((Object)blockState.method_26204())) {
                return null;
            }
            if (blockState.method_26215()) {
                return pos;
            }
            pos.method_10098(class_2350.field_11036);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(class_1936 level, int seaLevel, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        return blockState.method_26215() || blockState.method_27852(class_2246.field_10164) && pos.method_10264() <= seaLevel;
    }
}

