/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.adastra.common.registry.ModStructures;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_8889;
import net.minecraft.class_8891;

public class LargeJigsawStructure
extends class_3195 {
    public static final int MAX_DEPTH = 50;
    public static final Codec<LargeJigsawStructure> CODEC = class_5699.method_51699((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)LargeJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(jigsawStructure -> jigsawStructure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(jigsawStructure -> jigsawStructure.startJigsawName), (App)Codec.intRange((int)0, (int)50).fieldOf("size").forGetter(jigsawStructure -> jigsawStructure.maxDepth), (App)class_6122.field_31540.fieldOf("start_height").forGetter(jigsawStructure -> jigsawStructure.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(jigsawStructure -> jigsawStructure.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(jigsawStructure -> jigsawStructure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(jigsawStructure -> jigsawStructure.maxDistanceFromCenter), (App)Codec.list((Codec)class_8889.field_46825).optionalFieldOf("pool_aliases", List.of()).forGetter(jigsawStructure -> jigsawStructure.poolAliases)).apply((Applicative)instance, LargeJigsawStructure::new)), LargeJigsawStructure::verifyRange).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int maxDepth;
    private final class_6122 startHeight;
    private final boolean useExpansionHack;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final List<class_8889> poolAliases;

    private static DataResult<LargeJigsawStructure> verifyRange(LargeJigsawStructure structure) {
        int i = switch (structure.method_42701()) {
            default -> throw new IncompatibleClassChangeError();
            case class_5847.field_28922 -> 0;
            case class_5847.field_28923, class_5847.field_38431, class_5847.field_38432 -> 12;
        };
        return structure.maxDistanceFromCenter + i > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 128") : DataResult.success((Object)((Object)structure));
    }

    public LargeJigsawStructure(class_3195.class_7302 settings, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int maxDepth, class_6122 startHeight, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, List<class_8889> poolAliases) {
        super(settings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.poolAliases = poolAliases;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        int i = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), i, chunkPos.method_8328());
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (class_2338)blockPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (class_8891)class_8891.create(this.poolAliases, (class_2338)blockPos, (long)context.comp_567()));
    }

    public class_7151<?> method_41618() {
        return (class_7151)ModStructures.LARGE_JIGSAW_STRUCTURE.get();
    }
}

