/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui;

import fi.dy.masa.litematica.gui.GuiSchematicBrowserBase;
import fi.dy.masa.litematica.gui.Icons;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicBrowser;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetCheckBox;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import javax.annotation.Nullable;
import net.minecraft.class_332;

public abstract class GuiSchematicSaveBase
extends GuiSchematicBrowserBase
implements ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> {
    protected GuiTextFieldGeneric textField;
    protected WidgetCheckBox checkboxIgnoreEntities;
    protected WidgetCheckBox checkboxVisibleOnly;
    protected WidgetCheckBox checkboxIncludeSupportBlocks;
    protected final WidgetCheckBox checkboxSaveFromSchematicWorld;
    protected String lastText = "";
    protected String defaultText = "";
    @Nullable
    protected final LitematicaSchematic schematic;

    public GuiSchematicSaveBase(@Nullable LitematicaSchematic schematic) {
        super(10, 80);
        this.schematic = schematic;
        this.textField = new GuiTextFieldGeneric(10, 32, 160, 20, this.textRenderer);
        this.textField.method_1880(256);
        this.textField.method_25365(true);
        this.checkboxSaveFromSchematicWorld = new WidgetCheckBox(0, 0, (IGuiIcon)Icons.CHECKBOX_UNSELECTED, (IGuiIcon)Icons.CHECKBOX_SELECTED, "Save from schematic world", "If enabled, then the schematic is created by saving the\ncontents of the selection from the schematic world\ninstead of the normal vanilla world.\nThis allows you to combine or trim schematics without having\nto paste them to a temporary creative world.");
    }

    @Override
    public int getBrowserHeight() {
        return this.field_22790 - 80;
    }

    public void initGui() {
        super.initGui();
        boolean focused = this.textField.method_25370();
        String text = this.textField.method_1882();
        int pos = this.textField.getCursorPosition();
        this.textField = new GuiTextFieldGeneric(10, 32, this.field_22789 - 260, 18, this.textRenderer);
        this.textField.method_1852(text);
        this.textField.setCursorPosition(pos);
        this.textField.method_25365(focused);
        WidgetFileBrowserBase.DirectoryEntry entry = (WidgetFileBrowserBase.DirectoryEntry)((WidgetSchematicBrowser)this.getListWidget()).getLastSelectedEntry();
        if (this.lastText.isEmpty()) {
            if (entry != null && entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY && entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.INVALID) {
                this.setTextFieldText(FileUtils.getNameWithoutExtension((String)entry.getName()));
            } else if (this.schematic != null) {
                this.setTextFieldText(this.schematic.getMetadata().getName());
            } else {
                this.setTextFieldText(this.defaultText);
            }
        }
        int x = this.textField.method_46426() + this.textField.method_25368() + 4;
        int y = 28;
        String str = StringUtils.translate((String)"litematica.gui.label.schematic_save.checkbox.ignore_entities", (Object[])new Object[0]);
        this.checkboxIgnoreEntities = new WidgetCheckBox(x, y, (IGuiIcon)Icons.CHECKBOX_UNSELECTED, (IGuiIcon)Icons.CHECKBOX_SELECTED, str);
        this.addWidget((WidgetBase)this.checkboxIgnoreEntities);
        this.checkboxSaveFromSchematicWorld.setPosition(x, y + 12);
        this.addWidget((WidgetBase)this.checkboxSaveFromSchematicWorld);
        this.checkboxVisibleOnly = new WidgetCheckBox(x, y + 24, (IGuiIcon)Icons.CHECKBOX_UNSELECTED, (IGuiIcon)Icons.CHECKBOX_SELECTED, "Visible blocks only [experimental quick hax]");
        this.addWidget((WidgetBase)this.checkboxVisibleOnly);
        this.checkboxIncludeSupportBlocks = new WidgetCheckBox(x, y + 36, (IGuiIcon)Icons.CHECKBOX_UNSELECTED, (IGuiIcon)Icons.CHECKBOX_SELECTED, "Support blocks", "Include any necessary support blocks in \"Visible blocks only\" mode,\nfor things like Repeaters, Comparators, Carpets or gravity blocks that would be visible");
        this.addWidget((WidgetBase)this.checkboxIncludeSupportBlocks);
        this.createButton(10, 54, ButtonType.SAVE);
    }

    protected void setTextFieldText(String text) {
        this.lastText = text;
        this.textField.method_1852(text);
        this.textField.setCursorPositionEnd();
    }

    protected String getTextFieldText() {
        return this.textField.method_1882();
    }

    protected abstract IButtonActionListener createButtonListener(ButtonType var1);

    private int createButton(int x, int y, ButtonType type) {
        String label = StringUtils.translate((String)type.getLabelKey(), (Object[])new Object[0]);
        int width = this.getStringWidth(label) + 10;
        ButtonGeneric button = type == ButtonType.SAVE ? new ButtonGeneric(x, y, width, 20, label, new String[]{"litematica.gui.label.schematic_save.hoverinfo.hold_shift_to_overwrite"}) : new ButtonGeneric(x, y, width, 20, label, new String[0]);
        this.addButton((ButtonBase)button, this.createButtonListener(type));
        return x + width + 4;
    }

    public void setString(String string) {
        this.setNextMessageType(Message.MessageType.ERROR);
        super.setString(string);
    }

    public void drawContents(class_332 drawContext, int mouseX, int mouseY, float partialTicks) {
        super.drawContents(drawContext, mouseX, mouseY, partialTicks);
        this.textField.method_25394(drawContext, mouseX, mouseY, partialTicks);
    }

    public void onSelectionChange(@Nullable WidgetFileBrowserBase.DirectoryEntry entry) {
        if (entry != null && entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.DIRECTORY && entry.getType() != WidgetFileBrowserBase.DirectoryEntryType.INVALID) {
            this.setTextFieldText(FileUtils.getNameWithoutExtension((String)entry.getName()));
        }
    }

    @Override
    protected ISelectionListener<WidgetFileBrowserBase.DirectoryEntry> getSelectionListener() {
        return this;
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.textField.method_25402((double)mouseX, (double)mouseY, mouseButton)) {
            return true;
        }
        return super.onMouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        if (this.textField.method_25404(keyCode, scanCode, modifiers)) {
            ((WidgetSchematicBrowser)this.getListWidget()).clearSelection();
            return true;
        }
        if (keyCode == 258) {
            this.textField.method_25365(!this.textField.method_25370());
            return true;
        }
        return super.onKeyTyped(keyCode, scanCode, modifiers);
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        if (this.textField.method_25400(charIn, modifiers)) {
            ((WidgetSchematicBrowser)this.getListWidget()).clearSelection();
            return true;
        }
        return super.onCharTyped(charIn, modifiers);
    }

    public static enum ButtonType {
        SAVE("litematica.gui.button.save_schematic");

        private final String labelKey;

        private ButtonType(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getLabelKey() {
            return this.labelKey;
        }
    }
}

