/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public class PositionUtils {
    public static final class_2350[] ALL_DIRECTIONS = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    public static final class_2350[] HORIZONTAL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    public static final class_2350[] VERTICAL_DIRECTIONS = new class_2350[]{class_2350.field_11033, class_2350.field_11036};

    public static class_243 modifyValue(CoordinateType type, class_243 valueIn, double amount) {
        switch (type) {
            case X: {
                return new class_243(valueIn.field_1352 + amount, valueIn.field_1351, valueIn.field_1350);
            }
            case Y: {
                return new class_243(valueIn.field_1352, valueIn.field_1351 + amount, valueIn.field_1350);
            }
            case Z: {
                return new class_243(valueIn.field_1352, valueIn.field_1351, valueIn.field_1350 + amount);
            }
        }
        return valueIn;
    }

    public static class_2338 modifyValue(CoordinateType type, class_2338 valueIn, int amount) {
        switch (type) {
            case X: {
                return class_2338.method_49637((double)(valueIn.method_10263() + amount), (double)valueIn.method_10264(), (double)valueIn.method_10260());
            }
            case Y: {
                return class_2338.method_49637((double)valueIn.method_10263(), (double)(valueIn.method_10264() + amount), (double)valueIn.method_10260());
            }
            case Z: {
                return class_2338.method_49637((double)valueIn.method_10263(), (double)valueIn.method_10264(), (double)(valueIn.method_10260() + amount));
            }
        }
        return valueIn;
    }

    public static class_243 setValue(CoordinateType type, class_243 valueIn, double newValue) {
        switch (type) {
            case X: {
                return new class_243(newValue, valueIn.field_1351, valueIn.field_1350);
            }
            case Y: {
                return new class_243(valueIn.field_1352, newValue, valueIn.field_1350);
            }
            case Z: {
                return new class_243(valueIn.field_1352, valueIn.field_1351, newValue);
            }
        }
        return valueIn;
    }

    public static class_2338 setValue(CoordinateType type, class_2338 valueIn, int newValue) {
        switch (type) {
            case X: {
                return class_2338.method_49637((double)newValue, (double)valueIn.method_10264(), (double)valueIn.method_10260());
            }
            case Y: {
                return class_2338.method_49637((double)valueIn.method_10263(), (double)newValue, (double)valueIn.method_10260());
            }
            case Z: {
                return class_2338.method_49637((double)valueIn.method_10263(), (double)valueIn.method_10264(), (double)newValue);
            }
        }
        return valueIn;
    }

    public static class_2338 getEntityBlockPos(class_1297 entity) {
        return class_2338.method_49637((double)Math.floor(entity.method_23317()), (double)Math.floor(entity.method_23318()), (double)Math.floor(entity.method_23321()));
    }

    public static class_2350 getClosestLookingDirection(class_1297 entity) {
        return PositionUtils.getClosestLookingDirection(entity, 60.0f);
    }

    public static class_2350 getClosestLookingDirection(class_1297 entity, float verticalThreshold) {
        if (entity.method_36455() >= verticalThreshold) {
            return class_2350.field_11033;
        }
        if (entity.method_36454() <= -verticalThreshold) {
            return class_2350.field_11036;
        }
        return entity.method_5735();
    }

    public static class_2338 getPositionInfrontOfEntity(class_1297 entity) {
        return PositionUtils.getPositionInfrontOfEntity(entity, 60.0f);
    }

    public static class_2338 getPositionInfrontOfEntity(class_1297 entity, float verticalThreshold) {
        double x = entity.method_23317();
        double y = entity.method_23318();
        double z = entity.method_23321();
        double w = entity.method_17681();
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        if (entity.method_36455() >= verticalThreshold) {
            return pos.method_10087(1);
        }
        if (entity.method_36455() <= -verticalThreshold) {
            return class_2338.method_49637((double)x, (double)Math.ceil(entity.method_5829().field_1325), (double)z);
        }
        y = Math.floor(y + (double)entity.method_5751());
        switch (entity.method_5735()) {
            case field_11034: {
                return class_2338.method_49637((double)((int)Math.ceil(x + w / 2.0)), (double)((int)y), (double)((int)Math.floor(z)));
            }
            case field_11039: {
                return class_2338.method_49637((double)((int)Math.floor(x - w / 2.0) - 1), (double)((int)y), (double)((int)Math.floor(z)));
            }
            case field_11035: {
                return class_2338.method_49637((double)((int)Math.floor(x)), (double)((int)y), (double)((int)Math.ceil(z + w / 2.0)));
            }
            case field_11043: {
                return class_2338.method_49637((double)((int)Math.floor(x)), (double)((int)y), (double)((int)Math.floor(z - w / 2.0) - 1));
            }
        }
        return pos;
    }

    public static class_243 getHitVecCenter(class_2338 basePos, class_2350 facing) {
        int x = basePos.method_10263();
        int y = basePos.method_10264();
        int z = basePos.method_10260();
        switch (facing) {
            case field_11036: {
                return new class_243((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            case field_11033: {
                return new class_243((double)x + 0.5, (double)y, (double)z + 0.5);
            }
            case field_11043: {
                return new class_243((double)x + 0.5, (double)y + 0.5, (double)z);
            }
            case field_11035: {
                return new class_243((double)x + 0.5, (double)y + 0.5, (double)(z + 1));
            }
            case field_11039: {
                return new class_243((double)x, (double)y + 0.5, (double)z);
            }
            case field_11034: {
                return new class_243((double)(x + 1), (double)y + 0.5, (double)(z + 1));
            }
        }
        return new class_243((double)x, (double)y, (double)z);
    }

    public static HitPart getHitPart(class_2350 originalSide, class_2350 playerFacingH, class_2338 pos, class_243 hitVec) {
        class_243 positions = PositionUtils.getHitPartPositions(originalSide, playerFacingH, pos, hitVec);
        double posH = positions.field_1352;
        double posV = positions.field_1351;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (offH > offV) {
                return posH < 0.5 ? HitPart.LEFT : HitPart.RIGHT;
            }
            return posV < 0.5 ? HitPart.BOTTOM : HitPart.TOP;
        }
        return HitPart.CENTER;
    }

    private static class_243 getHitPartPositions(class_2350 originalSide, class_2350 playerFacingH, class_2338 pos, class_243 hitVec) {
        double x = hitVec.field_1352 - (double)pos.method_10263();
        double y = hitVec.field_1351 - (double)pos.method_10264();
        double z = hitVec.field_1350 - (double)pos.method_10260();
        double posH = 0.0;
        double posV = 0.0;
        switch (originalSide) {
            case field_11036: 
            case field_11033: {
                switch (playerFacingH) {
                    case field_11043: {
                        posH = x;
                        posV = 1.0 - z;
                        break;
                    }
                    case field_11035: {
                        posH = 1.0 - x;
                        posV = z;
                        break;
                    }
                    case field_11039: {
                        posH = 1.0 - z;
                        posV = 1.0 - x;
                        break;
                    }
                    case field_11034: {
                        posH = z;
                        posV = x;
                        break;
                    }
                }
                if (originalSide != class_2350.field_11033) break;
                posV = 1.0 - posV;
                break;
            }
            case field_11035: 
            case field_11043: {
                posH = originalSide.method_10171() == class_2350.class_2352.field_11056 ? x : 1.0 - x;
                posV = y;
                break;
            }
            case field_11034: 
            case field_11039: {
                posH = originalSide.method_10171() == class_2350.class_2352.field_11060 ? z : 1.0 - z;
                posV = y;
            }
        }
        return new class_243(posH, posV, 0.0);
    }

    public static class_2350 getTargetedDirection(class_2350 side, class_2350 playerFacingH, class_2338 pos, class_243 hitVec) {
        class_243 positions = PositionUtils.getHitPartPositions(side, playerFacingH, pos, hitVec);
        double posH = positions.field_1352;
        double posV = positions.field_1351;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (side.method_10166() == class_2350.class_2351.field_11052) {
                if (offH > offV) {
                    return posH < 0.5 ? playerFacingH.method_10160() : playerFacingH.method_10170();
                }
                if (side == class_2350.field_11033) {
                    return posV > 0.5 ? playerFacingH.method_10153() : playerFacingH;
                }
                return posV < 0.5 ? playerFacingH.method_10153() : playerFacingH;
            }
            if (offH > offV) {
                return posH < 0.5 ? side.method_10170() : side.method_10160();
            }
            return posV < 0.5 ? class_2350.field_11033 : class_2350.field_11036;
        }
        return side;
    }

    public static enum CoordinateType {
        X,
        Y,
        Z;

    }

    public static enum HitPart {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }
}

