/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IJeiClientConfigs;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SafeIngredientUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<?>> CRASHING_INGREDIENT_RENDER_CLASSES = new HashSet();
    private static final Set<Class<?>> CRASHING_INGREDIENT_TOOLTIP_CLASSES = new HashSet();

    private SafeIngredientUtil() {
    }

    public static <T> List<class_2561> getTooltip(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient) {
        class_310 minecraft = class_310.method_1551();
        class_1836.class_1837 tooltipFlag = minecraft.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        return SafeIngredientUtil.getTooltip(ingredientManager, ingredientRenderer, typedIngredient, tooltipFlag);
    }

    public static <T> List<class_2561> getTooltip(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, ITypedIngredient<T> typedIngredient, class_1836.class_1837 tooltipFlag) {
        T ingredient = typedIngredient.getIngredient();
        Class<?> ingredientClass = ingredient.getClass();
        if (CRASHING_INGREDIENT_TOOLTIP_CLASSES.contains(ingredientClass)) {
            return SafeIngredientUtil.getErrorTooltip();
        }
        try {
            List<class_2561> tooltip = ingredientRenderer.getTooltip(ingredient, (class_1836)tooltipFlag);
            return new ArrayList<class_2561>(tooltip);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_TOOLTIP_CLASSES.add(ingredientClass);
            if (SafeIngredientUtil.shouldCatchTooltipErrors()) {
                SafeIngredientUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient's tooltip", ingredientManager, typedIngredient);
                return SafeIngredientUtil.getErrorTooltip();
            }
            class_128 crashReport = SafeIngredientUtil.createIngredientCrashReport(e, "Rendering ingredient tooltip", ingredientManager, typedIngredient);
            throw new class_148(crashReport);
        }
    }

    private static List<class_2561> getErrorTooltip() {
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        class_5250 crash = class_2561.method_43471((String)"jei.tooltip.error.crash");
        list.add((class_2561)crash.method_27692(class_124.field_1061));
        return list;
    }

    public static <T> void render(IIngredientManager ingredientManager, IIngredientRenderer<T> ingredientRenderer, class_332 guiGraphics, ITypedIngredient<T> typedIngredient) {
        T ingredient = typedIngredient.getIngredient();
        Class<?> ingredientClass = ingredient.getClass();
        if (CRASHING_INGREDIENT_RENDER_CLASSES.contains(ingredientClass)) {
            SafeIngredientUtil.renderError(guiGraphics);
            return;
        }
        try {
            ingredientRenderer.render(guiGraphics, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            CRASHING_INGREDIENT_RENDER_CLASSES.add(ingredientClass);
            if (SafeIngredientUtil.shouldCatchRenderErrors()) {
                SafeIngredientUtil.logIngredientCrash(e, "Caught an error rendering an Ingredient", ingredientManager, typedIngredient);
                SafeIngredientUtil.renderError(guiGraphics);
            }
            class_128 crashReport = SafeIngredientUtil.createIngredientCrashReport(e, "Rendering ingredient", ingredientManager, typedIngredient);
            throw new class_148(crashReport);
        }
    }

    private static boolean shouldCatchRenderErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchRenderErrorsEnabled).orElse(false);
    }

    private static boolean shouldCatchTooltipErrors() {
        return Internal.getOptionalJeiClientConfigs().map(IJeiClientConfigs::getClientConfig).map(IClientConfig::isCatchTooltipRenderErrorsEnabled).orElse(false);
    }

    private static void renderError(class_332 guiGraphics) {
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        guiGraphics.method_51433(font, "ERR", 0, 0, -65536, false);
        guiGraphics.method_51433(font, "OR", 0, 8, -65536, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static <T> void logIngredientCrash(Throwable throwable, String title, IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        class_129 category = new class_129("Ingredient");
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        SafeIngredientUtil.setIngredientCategoryDetails(category, typedIngredient, ingredientHelper);
        LOGGER.error(SafeIngredientUtil.crashReportToString(throwable, title, category));
    }

    private static <T> class_128 createIngredientCrashReport(Throwable throwable, String title, IIngredientManager ingredientManager, ITypedIngredient<T> typedIngredient) {
        class_128 crashReport = class_128.method_560((Throwable)throwable, (String)title);
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        class_129 category = crashReport.method_562("Ingredient");
        SafeIngredientUtil.setIngredientCategoryDetails(category, typedIngredient, ingredientHelper);
        return crashReport;
    }

    private static <T> void setIngredientCategoryDetails(class_129 category, ITypedIngredient<T> typedIngredient, IIngredientHelper<T> ingredientHelper) {
        Object ingredient = typedIngredient.getIngredient();
        IIngredientType ingredientType = typedIngredient.getType();
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        category.method_577("Name", () -> ingredientHelper.getDisplayName(ingredient));
        category.method_577("Mod's Name", () -> {
            String modId = ingredientHelper.getDisplayModId(ingredient);
            return modHelper.getModNameForModId(modId);
        });
        category.method_577("Registry Name", () -> ingredientHelper.getResourceLocation(ingredient).toString());
        category.method_577("Class Name", () -> ingredient.getClass().toString());
        category.method_577("toString Name", ingredient::toString);
        category.method_577("Unique Id for JEI (for JEI Blacklist)", () -> ingredientHelper.getUniqueId(ingredient, UidContext.Ingredient));
        category.method_577("Ingredient Type for JEI", () -> ingredientType.getIngredientClass().toString());
        category.method_577("Error Info gathered from JEI", () -> ingredientHelper.getErrorInfo(ingredient));
    }

    private static String crashReportToString(Throwable t, String title, class_129 ... categories) {
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(":\n\n");
        for (class_129 category : categories) {
            category.method_574(sb);
            sb.append("\n\n");
        }
        sb.append("-- Stack Trace --\n\n");
        sb.append(ExceptionUtils.getStackTrace((Throwable)t));
        return sb.toString();
    }
}

