/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.lootmanager;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.configs.RSMainModdedLootConfig;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public class StructureModdedLootImporter {
    public static final Map<class_2960, class_2960> TABLE_IMPORTS = StructureModdedLootImporter.createMap();
    private static Set<class_2960> BLACKLISTED_LOOTTABLES;

    public static Map<class_2960, class_2960> createMap() {
        Object2ObjectOpenHashMap tableMap = new Object2ObjectOpenHashMap();
        tableMap.put(new class_2960("repurposed_structures", "chests/cities/nether"), new class_2960("minecraft:chests/bastion_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/cities/overworld"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ancient_cities/ocean"), new class_2960("minecraft:chests/ancient_city"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ancient_cities/ocean_ice_box"), new class_2960("minecraft:chests/ancient_city_ice_box"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ancient_cities/nether"), new class_2960("minecraft:chests/ancient_city"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ancient_cities/nether_magma_box"), new class_2960("minecraft:chests/ancient_city_ice_box"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ancient_cities/end"), new class_2960("minecraft:chests/ancient_city"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ancient_cities/end_spawner_box"), new class_2960("minecraft:chests/ancient_city_ice_box"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/treasure"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/bridge"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/other"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/skeleton_horse_stable"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/badlands"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/dark_forest"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/deep"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/desert"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/icy"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/jungle"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/mushroom"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/nether"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/ocean"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/snow"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeons/swamp"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/dungeons/end"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortresses/jungle_center"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortresses/jungle_hallway"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortresses/jungle_shrine"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/igloos/grassy"), new class_2960("minecraft:chests/igloo_chest"));
        tableMap.put(new class_2960("repurposed_structures", "chests/igloos/stone"), new class_2960("minecraft:chests/igloo_chest"));
        tableMap.put(new class_2960("repurposed_structures", "chests/igloos/mangrove"), new class_2960("minecraft:chests/igloo_chest"));
        tableMap.put(new class_2960("repurposed_structures", "chests/igloos/mushroom"), new class_2960("minecraft:chests/igloo_chest"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/birch"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/desert"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/jungle"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/mangrove"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/oak"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/savanna"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/snowy"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansions/taiga"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/basalt"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/birch"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/crimson"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/dark_forest"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/desert"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/end"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/icy"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/jungle"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/nether"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/ocean"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/savanna"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/soul"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/stone"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/swamp"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/taiga"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshafts/warped"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/basalt"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/badlands"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/birch"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/crimson"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/desert"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/giant_tree_taiga"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/icy"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/jungle"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/mangrove"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/nether_brick"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/oak"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/ocean"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/savanna"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/soul"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/snowy"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/taiga"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outposts/warped"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/outposts/end"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/dark_forest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/end"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/flower_forest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/giant_tree_taiga"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/icy"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/jungle"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/mushroom"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramids/snowy"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "trapped_chests/pyramids/badlands"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "trapped_chests/pyramids/end"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "trapped_chests/pyramids/nether"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "trapped_chests/pyramids/ocean"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/pyramids/dark_forest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruined_portals/end/large_portal"), new class_2960("minecraft:chests/ruined_portal"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruined_portals/end/small_portal"), new class_2960("minecraft:chests/ruined_portal"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_hot/large"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_hot/small"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_warm/large"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_warm/small"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_cold/large"), new class_2960("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_cold/small"), new class_2960("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_icy/large"), new class_2960("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/land_icy/small"), new class_2960("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruins/nether"), new class_2960("minecraft:chests/bastion_other"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/crimson/map"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/crimson/supply"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/crimson/treasure"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/end/map"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/end/supply"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/end/treasure"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/warped/map"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/warped/supply"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/warped/treasure"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwrecks/nether_bricks/treasure"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/strongholds/end_storage_room"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/strongholds/end_hallway"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "shulker_boxes/strongholds/end_library"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/strongholds/nether_storage_room"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/strongholds/nether_hallway"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/strongholds/nether_library"), new class_2960("minecraft:chests/stronghold_library"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/basalt"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/crimson"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/soul"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/warped"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/wasteland"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/taiga"), new class_2960("minecraft:chests/jungle_temple"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temples/ocean"), new class_2960("minecraft:chests/jungle_temple"));
        tableMap.put(new class_2960("repurposed_structures", "trapped_chests/temples/warped"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/basalt"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/crimson"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/soul"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/warped"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/wasteland"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "dispensers/temples/taiga"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/badlands_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/bamboo_house"), new class_2960("minecraft:chests/village/village_savanna_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/birch_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/cherry_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/dark_forest_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/giant_taiga_house"), new class_2960("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/jungle_house"), new class_2960("minecraft:chests/village/village_savanna_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/mountains_house"), new class_2960("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/mushroom_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/oak_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/ocean_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/ocean_cartographer"), new class_2960("minecraft:chests/village/village_cartographer"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/swamp_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_cartographer"), new class_2960("minecraft:chests/village/village_cartographer"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_fisher"), new class_2960("minecraft:chests/village/village_fisher"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_tannery"), new class_2960("minecraft:chests/village/village_tannery"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_weaponsmith"), new class_2960("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/crimson_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_cartographer"), new class_2960("minecraft:chests/village/village_cartographer"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_fisher"), new class_2960("minecraft:chests/village/village_fisher"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_tannery"), new class_2960("minecraft:chests/village/village_tannery"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_weaponsmith"), new class_2960("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new class_2960("repurposed_structures", "chests/villages/warped_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        if (PlatformHooks.isModLoaded("betterstrongholds")) {
            tableMap.put(new class_2960("betterstrongholds", "chests/end/armoury"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/common"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/crypt"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/grand_library"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/library_md"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/mess"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/prison_lg"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/trap"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/end/treasure"), new class_2960("minecraft:chests/end_city_treasure"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/common"), new class_2960("minecraft:chests/stronghold_crossing"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/mess"), new class_2960("minecraft:chests/stronghold_crossing"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/armoury"), new class_2960("minecraft:chests/stronghold_corridor"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/crypt"), new class_2960("minecraft:chests/stronghold_corridor"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/prison_lg"), new class_2960("minecraft:chests/stronghold_corridor"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/trap"), new class_2960("minecraft:chests/stronghold_corridor"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/treasure"), new class_2960("minecraft:chests/stronghold_corridor"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/grand_library"), new class_2960("minecraft:chests/stronghold_library"));
            tableMap.put(new class_2960("betterstrongholds", "chests/nether/library_md"), new class_2960("minecraft:chests/stronghold_library"));
        }
        return tableMap;
    }

    public static boolean isInBlacklist(class_2960 lootTableID) {
        if (BLACKLISTED_LOOTTABLES == null) {
            String cleanedBlacklist = RSMainModdedLootConfig.blacklistedRSLoottablesFromImportingModdedItems.trim();
            BLACKLISTED_LOOTTABLES = cleanedBlacklist.isEmpty() ? new HashSet<class_2960>() : Arrays.stream(cleanedBlacklist.split(",")).map(String::trim).map(class_2960::new).collect(Collectors.toSet());
        }
        return BLACKLISTED_LOOTTABLES.contains(lootTableID);
    }

    public static void checkLoottables(MinecraftServer minecraftServer) {
        boolean invalidLootTableFound = false;
        for (Map.Entry<class_2960, class_2960> entry : TABLE_IMPORTS.entrySet()) {
            if (entry.getKey().method_12836().equals("betterstrongholds") || !GeneralUtils.isInvalidLootTableFound(minecraftServer, entry)) continue;
            invalidLootTableFound = true;
        }
        if (GeneralUtils.isMissingLootImporting(minecraftServer, TABLE_IMPORTS.keySet())) {
            invalidLootTableFound = true;
        }
        if (invalidLootTableFound) {
            RepurposedStructures.LOGGER.error("Unknown import/target loot tables found for Repurposed Structures. See above logs and report to TelepathicGrunt please.");
        }
    }
}

