/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixins.structures.JigsawJunctionAccessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3748;
import net.minecraft.class_3790;
import net.minecraft.class_4538;
import net.minecraft.class_4966;
import net.minecraft.class_5000;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_7138;
import net.minecraft.class_7923;
import net.minecraft.class_8490;
import net.minecraft.server.MinecraftServer;

public final class GeneralUtils {
    private static final Map<class_2680, Boolean> IS_FULLCUBE_MAP = new ConcurrentHashMap<class_2680, Boolean>();

    private GeneralUtils() {
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, class_5819 random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.method_43057() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(class_1922 world, class_2338 pos, class_2680 state) {
        if (state == null) {
            return false;
        }
        return IS_FULLCUBE_MAP.computeIfAbsent(state, stateIn -> class_2248.method_9614((class_265)stateIn.method_26201(world, pos)));
    }

    public static class_2680 orientateChest(class_5425 blockView, class_2338 blockPos, class_2680 blockState) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2350 wallDirection = (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)blockPos).method_10098(facing);
            if (!GeneralUtils.isFullCube((class_1922)blockView, (class_2338)mutable, blockView.method_8320((class_2338)mutable))) continue;
            wallDirection = facing;
            mutable.method_10104(facing.method_10153(), 2);
            if (blockView.method_8320((class_2338)mutable).method_51367()) continue;
            break;
        }
        return (class_2680)blockState.method_11657((class_2769)class_2383.field_11177, (Comparable)wallDirection.method_10153());
    }

    public static class_1799 enchantRandomly(class_5819 random, class_1799 itemToEnchant, float chance) {
        List<class_1887> list;
        if (random.method_43057() < chance && !(list = class_7923.field_41176.method_10220().filter(class_1887::method_25950).filter(enchantmentToCheck -> enchantmentToCheck.method_8192(itemToEnchant)).toList()).isEmpty()) {
            class_1887 enchantment = list.get(random.method_43048(list.size()));
            int enchantmentLevel = random.method_43048(class_3532.method_15395((class_5819)random, (int)enchantment.method_8187(), (int)enchantment.method_8183()) + 1);
            itemToEnchant.method_7978(enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }

    public static int getMaxTerrainLimit(class_2794 chunkGenerator) {
        return chunkGenerator.method_33730() + chunkGenerator.method_12104();
    }

    public static class_2338 getHighestLand(class_2794 chunkGenerator, class_7138 randomState, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView, randomState);
        while (mutable.method_10264() > chunkGenerator.method_16398()) {
            class_2680 currentBlockstate = blockView.method_32892(mutable.method_10264());
            if (!currentBlockstate.method_26225()) {
                mutable.method_10098(class_2350.field_11033);
                continue;
            }
            if (blockView.method_32892(mutable.method_10264() + 3).method_26215() && (canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225())) {
                return mutable;
            }
            mutable.method_10098(class_2350.field_11033);
        }
        return mutable;
    }

    public static class_2338 getLowestLand(class_2794 chunkGenerator, class_7138 randomState, class_3341 boundingBox, class_5539 heightLimitView, boolean canBeOnLiquid) {
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10103(boundingBox.method_22874().method_10263(), chunkGenerator.method_16398() + 1, boundingBox.method_22874().method_10260());
        class_4966 blockView = chunkGenerator.method_26261(mutable.method_10263(), mutable.method_10260(), heightLimitView, randomState);
        class_2680 currentBlockstate = blockView.method_32892(mutable.method_10264());
        while (mutable.method_10264() <= GeneralUtils.getMaxTerrainLimit(chunkGenerator) - 40) {
            if ((canBeOnLiquid ? !currentBlockstate.method_26215() : currentBlockstate.method_26225()) && blockView.method_32892(mutable.method_10264() + 1).method_26215() && blockView.method_32892(mutable.method_10264() + 5).method_26215()) {
                mutable.method_10098(class_2350.field_11036);
                return mutable;
            }
            mutable.method_10098(class_2350.field_11036);
            currentBlockstate = blockView.method_32892(mutable.method_10264());
        }
        return mutable.method_10103(mutable.method_10263(), chunkGenerator.method_16398(), mutable.method_10260());
    }

    public static int getFirstLandYFromPos(class_4538 worldView, class_2338 pos) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        mutable.method_10101((class_2382)pos);
        class_2791 currentChunk = worldView.method_22350((class_2338)mutable);
        class_2680 currentState = currentChunk.method_8320((class_2338)mutable);
        while (mutable.method_10264() >= worldView.method_31607() && GeneralUtils.isReplaceableByStructures(currentState)) {
            mutable.method_10098(class_2350.field_11033);
            currentState = currentChunk.method_8320((class_2338)mutable);
        }
        return mutable.method_10264();
    }

    private static boolean isReplaceableByStructures(class_2680 blockState) {
        return blockState.method_26215() || !blockState.method_26227().method_15769() || blockState.method_26164(class_3481.field_44470);
    }

    public static void centerAllPieces(class_2338 targetPos, List<? extends class_3443> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        class_2338 structureCenter = pieces.get(0).method_14935().method_22874();
        int xOffset = targetPos.method_10263() - structureCenter.method_10263();
        int zOffset = targetPos.method_10260() - structureCenter.method_10260();
        for (class_3443 class_34432 : pieces) {
            class_34432.method_14922(xOffset, 0, zOffset);
        }
    }

    public static void movePieceProperly(class_3443 piece, int x, int y, int z) {
        piece.method_14922(x, y, z);
        if (piece instanceof class_3790) {
            class_3790 poolElementStructurePiece = (class_3790)piece;
            poolElementStructurePiece.method_16645().forEach(junction -> {
                ((JigsawJunctionAccessor)junction).setSourceX(junction.method_16610() + x);
                ((JigsawJunctionAccessor)junction).setSourceX(junction.method_16611() + y);
                ((JigsawJunctionAccessor)junction).setSourceX(junction.method_16609() + z);
            });
        }
    }

    public static boolean canJigsawsAttach(class_3499.class_3501 jigsaw1, class_3499.class_3501 jigsaw2) {
        class_5000 prop1 = (class_5000)jigsaw1.comp_1342().method_11654((class_2769)class_3748.field_23262);
        class_5000 prop2 = (class_5000)jigsaw2.comp_1342().method_11654((class_2769)class_3748.field_23262);
        String joint = jigsaw1.comp_1343().method_10558("joint");
        if (joint.isEmpty()) {
            joint = prop1.method_26426().method_10166().method_10179() ? "aligned" : "rollable";
        }
        boolean isRollable = joint.equals("rollable");
        return prop1.method_26426() == prop2.method_26426().method_10153() && (isRollable || prop1.method_26428() == prop2.method_26428()) && jigsaw1.comp_1343().method_10558("target").equals(jigsaw2.comp_1343().method_10558("name"));
    }

    public static Map<class_2960, List<JsonElement>> getAllDatapacksJSONElement(class_3300 resourceManager, Gson gson, String dataType, int fileSuffixLength) {
        HashMap<class_2960, List<JsonElement>> map = new HashMap<class_2960, List<JsonElement>>();
        int dataTypeLength = dataType.length() + 1;
        for (Map.Entry resourceStackEntry : resourceManager.method_41265(dataType, fileString -> fileString.toString().endsWith(".json")).entrySet()) {
            String identifierPath = ((class_2960)resourceStackEntry.getKey()).method_12832();
            class_2960 fileID = new class_2960(((class_2960)resourceStackEntry.getKey()).method_12836(), identifierPath.substring(dataTypeLength, identifierPath.length() - fileSuffixLength));
            try {
                for (class_3298 resource : (List)resourceStackEntry.getValue()) {
                    InputStream fileStream = resource.method_14482();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));){
                        JsonElement countsJSONElement = (JsonElement)class_3518.method_15276((Gson)gson, (Reader)bufferedReader, JsonElement.class);
                        if (countsJSONElement != null) {
                            if (!map.containsKey(fileID)) {
                                map.put(fileID, new ArrayList());
                            }
                            ((List)map.get(fileID)).add(countsJSONElement);
                            continue;
                        }
                        RepurposedStructures.LOGGER.error("(Repurposed Structures {} MERGER) Couldn't load data file {} from {} as it's null or empty", (Object)dataType, (Object)fileID, resourceStackEntry);
                    }
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RepurposedStructures.LOGGER.error("(Repurposed Structures {} MERGER) Couldn't parse data file {} from {}", (Object)dataType, (Object)fileID, resourceStackEntry, (Object)exception);
            }
        }
        return map;
    }

    public static boolean isInvalidLootTableFound(MinecraftServer minecraftServer, Map.Entry<class_2960, class_2960> entry) {
        boolean invalidLootTableFound = false;
        if (minecraftServer.method_3857().getLootTable(entry.getKey()) == class_52.field_948) {
            RepurposedStructures.LOGGER.error("Unable to find loot table key: {}", (Object)entry.getKey());
            invalidLootTableFound = true;
        }
        if (minecraftServer.method_3857().getLootTable(entry.getValue()) == class_52.field_948) {
            RepurposedStructures.LOGGER.error("Unable to find loot table value: {}", (Object)entry.getValue());
            invalidLootTableFound = true;
        }
        return invalidLootTableFound;
    }

    public static boolean isMissingLootImporting(MinecraftServer minecraftServer, Set<class_2960> tableKeys) {
        AtomicBoolean invalidLootTableFound = new AtomicBoolean(false);
        minecraftServer.method_3857().method_51193(class_8490.field_44498).forEach(rl -> {
            if (rl.method_12836().equals("repurposed_structures") && !tableKeys.contains(rl)) {
                if (rl.method_12832().contains("mansions") && rl.method_12832().contains("storage")) {
                    return;
                }
                if (rl.method_12832().contains("monuments")) {
                    return;
                }
                if (rl.method_12832().contains("dispensers/temples/wasteland_lava")) {
                    return;
                }
                if (rl.method_12832().contains("lucky_pool")) {
                    return;
                }
                if (rl.method_12832().contains("archaeology")) {
                    return;
                }
                RepurposedStructures.LOGGER.error("No loot importing found for: {}", rl);
                invalidLootTableFound.set(true);
            }
        });
        return invalidLootTableFound.get();
    }

    public static boolean nameMatch(String biomeName, String ... targetMatch) {
        return Arrays.stream(targetMatch).anyMatch(biomeName::contains);
    }

    public static boolean nameExactMatch(String biomeName, String ... targetMatch) {
        return Arrays.asList(targetMatch).contains(biomeName);
    }

    public static class_2680 copyBlockProperties(class_2680 oldBlockState, class_2680 newBlockState) {
        for (class_2769 property : oldBlockState.method_28501()) {
            if (!newBlockState.method_28498(property)) continue;
            newBlockState = GeneralUtils.getStateWithProperty(newBlockState, oldBlockState, property);
        }
        return newBlockState;
    }

    public static <T extends Comparable<T>> class_2680 getStateWithProperty(class_2680 state, class_2680 stateToCopy, class_2769<T> property) {
        return (class_2680)state.method_11657(property, stateToCopy.method_11654(property));
    }
}

