/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.mobspawners.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.mixins.structures.TemplateAccessor;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.features.configs.NbtDungeonConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2496;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3485;
import net.minecraft.class_3486;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5497;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8934;

public class NbtDungeon
extends class_3031<NbtDungeonConfig> {
    public NbtDungeon(Codec<NbtDungeonConfig> configFactory) {
        super(configFactory);
    }

    public boolean method_13151(class_5821<NbtDungeonConfig> context) {
        class_2338 position = context.method_33655().method_10086(-1);
        class_2960 nbtRL = (class_2960)GeneralUtils.getRandomEntry(((NbtDungeonConfig)context.method_33656()).nbtResourcelocationsAndWeights, context.method_33654());
        class_3485 structureTemplateManager = context.method_33652().method_8410().method_14183();
        Optional template = structureTemplateManager.method_15094(nbtRL);
        if (template.isEmpty()) {
            RepurposedStructures.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)nbtRL);
            return false;
        }
        class_2470 rotation = class_2470.method_16548((class_5819)context.method_33654());
        class_2338 size = new class_2338(((class_3499)template.get()).method_15160());
        class_2338 halfLengths = new class_2338(size.method_10263() / 2, size.method_10264() / 2, size.method_10260() / 2);
        class_2338 fullLengths = new class_2338(Math.abs(size.method_10070(rotation).method_10263()), Math.abs(size.method_10070(rotation).method_10264()), Math.abs(size.method_10070(rotation).method_10260()));
        class_2338 halfLengthsRotated = new class_2338(fullLengths.method_10263() / 2, fullLengths.method_10264() / 2, fullLengths.method_10260() / 2);
        class_2338.class_2339 mutable = new class_2338.class_2339().method_10101((class_2382)position);
        class_2791 cachedChunk = context.method_33652().method_22350((class_2338)mutable);
        int xMin = -halfLengthsRotated.method_10263();
        int xMax = halfLengthsRotated.method_10263();
        int zMin = -halfLengthsRotated.method_10260();
        int zMax = halfLengthsRotated.method_10260();
        int wallOpenings = 0;
        int ceilingOpenings = 0;
        int ceiling = size.method_10264();
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                for (int y = 0; y <= ceiling; ++y) {
                    mutable.method_10101((class_2382)position).method_10100(x, y, z);
                    if (mutable.method_10263() >> 4 != cachedChunk.method_12004().field_9181 || mutable.method_10260() >> 4 != cachedChunk.method_12004().field_9180) {
                        cachedChunk = context.method_33652().method_22350((class_2338)mutable);
                    }
                    class_2680 state = cachedChunk.method_8320((class_2338)mutable);
                    if (((NbtDungeonConfig)context.method_33656()).airRequirementIsNowWater ? state.method_26215() || state.method_26227().method_15767(class_3486.field_15518) : !state.method_26227().method_15769()) {
                        return false;
                    }
                    if (!GeneralUtils.isFullCube((class_1922)context.method_33652(), (class_2338)mutable, state)) {
                        if (y == 0 && !state.method_51367()) {
                            return false;
                        }
                        if (state.method_26164(class_3481.field_15503)) continue;
                        if (y == ceiling) {
                            ++ceilingOpenings;
                        }
                    }
                    if ((x == xMin || x == xMax || z == zMin || z == zMax) && y == 1 && this.isValidNonSolidBlock((NbtDungeonConfig)context.method_33656(), state)) {
                        class_2680 aboveState = cachedChunk.method_8320((class_2338)mutable);
                        if (((NbtDungeonConfig)context.method_33656()).airRequirementIsNowWater ? !aboveState.method_26227().method_15769() : aboveState.method_26215()) {
                            ++wallOpenings;
                        }
                    }
                    if (wallOpenings <= ((NbtDungeonConfig)context.method_33656()).maxAirSpace && ceilingOpenings <= ((NbtDungeonConfig)context.method_33656()).maxAirSpace) continue;
                    return false;
                }
            }
        }
        if (wallOpenings >= ((NbtDungeonConfig)context.method_33656()).minAirSpace) {
            position = position.method_10086(((NbtDungeonConfig)context.method_33656()).structureYOffset);
            class_2378 processorListRegistry = context.method_33652().method_8410().method_8503().method_30611().method_30530(class_7924.field_41247);
            class_5321 emptyKey = class_5321.method_29179((class_5321)class_7924.field_41247, (class_2960)new class_2960("minecraft", "empty"));
            class_3492 placementsettings = new class_3492().method_15123(rotation).method_15119(halfLengths).method_15133(false);
            Optional processor = processorListRegistry.method_17966(((NbtDungeonConfig)context.method_33656()).processor);
            processor.orElse((class_5497)((class_6880.class_6883)processorListRegistry.method_40264(emptyKey).get()).comp_349()).method_31027().forEach(arg_0 -> ((class_3492)placementsettings).method_16184(arg_0));
            class_2338.class_2339 finalPos = mutable.method_10101((class_2382)position).method_10100(-halfLengths.method_10263(), 0, -halfLengths.method_10260());
            ((class_3499)template.get()).method_15172((class_5425)context.method_33652(), (class_2338)finalPos, (class_2338)finalPos, placementsettings, context.method_33654(), 2);
            placementsettings.method_16183();
            Optional postProcessor = processorListRegistry.method_17966(((NbtDungeonConfig)context.method_33656()).processor);
            postProcessor.orElse((class_5497)((class_6880.class_6883)processorListRegistry.method_40264(emptyKey).get()).comp_349()).method_31027().forEach(arg_0 -> ((class_3492)placementsettings).method_16184(arg_0));
            List list = placementsettings.method_15121(((TemplateAccessor)template.get()).repurposedstructures_getPalettes(), (class_2338)mutable).method_27125();
            class_3499.method_16446((class_5425)context.method_33652(), (class_2338)mutable, (class_2338)mutable, (class_3492)placementsettings, (List)list);
            this.spawnLootBlocks(context.method_33652(), context.method_33654(), position, (NbtDungeonConfig)context.method_33656(), fullLengths, halfLengthsRotated, mutable);
            return true;
        }
        return false;
    }

    private boolean isValidNonSolidBlock(NbtDungeonConfig config, class_2680 state) {
        if (config.airRequirementIsNowWater) {
            return !state.method_26227().method_15769();
        }
        return state.method_26215();
    }

    private void SolidifyBlock(class_5281 world, class_2338 pos) {
        class_2680 blockBelow = world.method_8320(pos);
        if (blockBelow.method_28498((class_2769)class_2482.field_11501)) {
            world.method_8652(pos, (class_2680)blockBelow.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682), 3);
        }
    }

    private void spawnLootBlocks(class_5281 world, class_5819 random, class_2338 position, NbtDungeonConfig config, class_2338 fullLengths, class_2338 halfLengths, class_2338.class_2339 mutable) {
        boolean isPlacingChestLikeBlock = config.lootBlock.method_9564().method_26204() instanceof class_2281;
        int currentChestAttempt = 0;
        while (currentChestAttempt < config.maxNumOfChests) {
            boolean addedChestThisAttempt = false;
            for (int currentChestPosAttempt = 0; currentChestPosAttempt < fullLengths.method_10263() + fullLengths.method_10260() + halfLengths.method_10264(); ++currentChestPosAttempt) {
                class_2680 belowState;
                if (config.chanceOfSpawningLootBlockAtSpot.isPresent() && random.method_43057() >= config.chanceOfSpawningLootBlockAtSpot.get().floatValue()) continue;
                mutable.method_10101((class_2382)position).method_10100(random.method_43048(Math.max(fullLengths.method_10263() - 2, 1)) - halfLengths.method_10263() + 1, random.method_43048(Math.max(fullLengths.method_10264() - 1, 1)), random.method_43048(Math.max(fullLengths.method_10260() - 2, 1)) - halfLengths.method_10260() + 1);
                class_2680 currentBlock = world.method_8320((class_2338)mutable);
                if (!this.isValidNonSolidBlock(config, currentBlock) || !(belowState = world.method_8320((class_2338)mutable.method_10098(class_2350.field_11033))).method_26206((class_1922)world, (class_2338)mutable, class_2350.field_11036) || belowState.method_26204() == config.lootBlock) continue;
                mutable.method_10098(class_2350.field_11036);
                boolean isOnWall = false;
                for (class_2350 neighborDirection : class_2350.class_2353.field_11062) {
                    mutable.method_10098(neighborDirection);
                    class_2680 neighboringState = world.method_8320((class_2338)mutable);
                    mutable.method_10098(neighborDirection.method_10153());
                    if (isPlacingChestLikeBlock && neighboringState.method_26204() instanceof class_2281) {
                        boolean chestTyping;
                        if (neighboringState.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569) continue;
                        class_2680 currentStateForChest = GeneralUtils.orientateChest((class_5425)world, (class_2338)mutable, config.lootBlock.method_9564());
                        class_2350 currentDirection = (class_2350)currentStateForChest.method_11654((class_2769)class_2383.field_11177);
                        if (neighborDirection.method_10166() == currentDirection.method_10166()) {
                            currentDirection = currentDirection.method_10170();
                            class_2338 wallCheckPos = mutable.method_10093(currentDirection);
                            class_2338 wallCheckPos2 = wallCheckPos.method_10093(neighborDirection);
                            class_2680 blockState = world.method_8320(wallCheckPos);
                            class_2680 blockState2 = world.method_8320(wallCheckPos2);
                            if (blockState.method_51367() && !(blockState.method_26204() instanceof class_2496) || blockState2.method_51367() && !(blockState2.method_26204() instanceof class_2496)) {
                                currentDirection = currentDirection.method_10153();
                            }
                        }
                        boolean bl = chestTyping = neighborDirection.method_10171() == currentDirection.method_10171();
                        if (neighborDirection.method_10166() == class_2350.class_2351.field_11051) {
                            chestTyping = !chestTyping;
                        }
                        world.method_8652((class_2338)mutable, (class_2680)((class_2680)((class_2680)config.lootBlock.method_9564().method_11657((class_2769)class_2281.field_10772, (Comparable)Boolean.valueOf(currentBlock.method_26227().method_15767(class_3486.field_15517)))).method_11657((class_2769)class_2281.field_10768, (Comparable)currentDirection)).method_11657((class_2769)class_2281.field_10770, (Comparable)(chestTyping ? class_2745.field_12571 : class_2745.field_12574)), 2);
                        class_8934.method_54868((class_1922)world, (class_5819)random, (class_2338)mutable, (class_2960)config.chestResourcelocation);
                        world.method_8652((class_2338)mutable.method_10098(neighborDirection), (class_2680)((class_2680)neighboringState.method_11657((class_2769)class_2281.field_10768, (Comparable)currentDirection)).method_11657((class_2769)class_2281.field_10770, (Comparable)(chestTyping ? class_2745.field_12574 : class_2745.field_12571)), 2);
                        class_8934.method_54868((class_1922)world, (class_5819)random, (class_2338)mutable, (class_2960)config.chestResourcelocation);
                        this.SolidifyBlock(world, mutable.method_10074());
                        isOnWall = false;
                        addedChestThisAttempt = true;
                        if (++currentChestAttempt != config.maxNumOfChests) break;
                        return;
                    }
                    if (!GeneralUtils.isFullCube((class_1922)world, (class_2338)mutable, neighboringState) || neighboringState.method_26204() instanceof class_2496) continue;
                    isOnWall = true;
                }
                if (!isOnWall) continue;
                class_2680 lootBlock = config.lootBlock.method_9564();
                if (lootBlock.method_28498((class_2769)class_2741.field_12508)) {
                    lootBlock.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(currentBlock.method_26227().method_15767(class_3486.field_15517)));
                }
                if (lootBlock.method_28498((class_2769)class_2741.field_12481)) {
                    lootBlock = GeneralUtils.orientateChest((class_5425)world, (class_2338)mutable, lootBlock);
                }
                world.method_8652((class_2338)mutable, lootBlock, 2);
                ++currentChestAttempt;
                addedChestThisAttempt = true;
                class_8934.method_54868((class_1922)world, (class_5819)random, (class_2338)mutable, (class_2960)config.chestResourcelocation);
                mutable.method_10098(class_2350.field_11033);
                if (lootBlock.method_26204() == class_2246.field_10603 && world.method_8321((class_2338)mutable) == null) {
                    class_1299<?> entity = MobSpawnerManager.MOB_SPAWNER_MANAGER.getSpawnerMob(config.rsSpawnerResourcelocation, random);
                    if (entity == null) break;
                    world.method_8652((class_2338)mutable, class_2246.field_10260.method_9564(), 2);
                    class_2586 blockEntity = world.method_8321((class_2338)mutable);
                    if (!(blockEntity instanceof class_2636)) break;
                    class_2636 spawnerBlockEntity = (class_2636)blockEntity;
                    spawnerBlockEntity.method_11390().method_8274(entity, null, random, (class_2338)mutable);
                    break;
                }
                this.SolidifyBlock(world, (class_2338)mutable);
                break;
            }
            if (addedChestThisAttempt) continue;
            ++currentChestAttempt;
        }
    }
}

