/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.entries;

import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.jetbrains.annotations.ApiStatus;

public interface ResourcefulConfigFieldBackedValueEntry
extends ResourcefulConfigValueEntry {
    public Field field();

    @Override
    default public Object get() {
        try {
            return this.field().get(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse(null);
        }
    }

    @Override
    default public boolean setArray(Object[] array) {
        try {
            for (Object o : array) {
                if (this.type().test(o.getClass())) continue;
                return false;
            }
            this.field().set(this.instance(), ResourcefulConfigFieldBackedValueEntry.castArray(array, this.field().getType().componentType()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public byte getByte() {
        if (this.type() != EntryType.BYTE) {
            return 0;
        }
        try {
            return this.field().getByte(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse((byte)0);
        }
    }

    @Override
    default public boolean setByte(byte value) {
        if (this.type() != EntryType.BYTE) {
            return false;
        }
        try {
            EntryData options = this.options();
            if (options.hasRange() && !options.inRange(value)) {
                this.reset();
                return false;
            }
            this.field().setByte(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public short getShort() {
        if (this.type() != EntryType.SHORT) {
            return 0;
        }
        try {
            return this.field().getShort(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse((short)0);
        }
    }

    @Override
    default public boolean setShort(short value) {
        if (this.type() != EntryType.SHORT) {
            return false;
        }
        try {
            EntryData options = this.options();
            if (options.hasRange() && !options.inRange(value)) {
                this.reset();
                return false;
            }
            this.field().setShort(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public int getInt() {
        if (this.type() != EntryType.INTEGER) {
            return 0;
        }
        try {
            return this.field().getInt(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse(0);
        }
    }

    @Override
    default public boolean setInt(int value) {
        if (this.type() != EntryType.INTEGER) {
            return false;
        }
        try {
            EntryData options = this.options();
            if (options.hasRange() && !options.inRange(value)) {
                this.reset();
                return false;
            }
            this.field().setInt(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public long getLong() {
        if (this.type() != EntryType.LONG) {
            return 0L;
        }
        try {
            return this.field().getLong(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse(0L);
        }
    }

    @Override
    default public boolean setLong(long value) {
        if (this.type() != EntryType.LONG) {
            return false;
        }
        try {
            EntryData options = this.options();
            if (options.hasRange() && !options.inRange(value)) {
                this.reset();
                return false;
            }
            this.field().setLong(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public float getFloat() {
        if (this.type() != EntryType.FLOAT) {
            return 0.0f;
        }
        try {
            return this.field().getFloat(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse(Float.valueOf(0.0f)).floatValue();
        }
    }

    @Override
    default public boolean setFloat(float value) {
        if (this.type() != EntryType.FLOAT) {
            return false;
        }
        try {
            EntryData options = this.options();
            if (options.hasRange() && !options.inRange(value)) {
                this.reset();
                return false;
            }
            this.field().setFloat(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public double getDouble() {
        if (this.type() != EntryType.DOUBLE) {
            return 0.0;
        }
        try {
            return this.field().getDouble(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse(0.0);
        }
    }

    @Override
    default public boolean setDouble(double value) {
        if (this.type() != EntryType.DOUBLE) {
            return false;
        }
        try {
            EntryData options = this.options();
            if (options.hasRange() && !options.inRange(value)) {
                this.reset();
                return false;
            }
            this.field().setDouble(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public boolean getBoolean() {
        if (this.type() != EntryType.BOOLEAN) {
            return false;
        }
        try {
            return this.field().getBoolean(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse(false);
        }
    }

    @Override
    default public boolean setBoolean(boolean value) {
        if (this.type() != EntryType.BOOLEAN) {
            return false;
        }
        try {
            this.field().setBoolean(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public String getString() {
        if (this.type() != EntryType.STRING) {
            return "";
        }
        try {
            return (String)this.field().get(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse("");
        }
    }

    @Override
    default public boolean setString(String value) {
        if (this.type() != EntryType.STRING) {
            return false;
        }
        if (value == null) {
            return false;
        }
        try {
            EntryData options = this.options();
            if (options.hasRegex() && !options.matchesRegex(value)) {
                this.reset();
                return false;
            }
            this.field().set(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    default public Enum<?> getEnum() {
        if (this.type() != EntryType.ENUM) {
            return null;
        }
        try {
            return (Enum)this.field().get(this.instance());
        }
        catch (IllegalAccessException e) {
            return this.defaultOrElse(null);
        }
    }

    @Override
    default public boolean setEnum(Enum<?> value) {
        if (this.type() != EntryType.ENUM) {
            return false;
        }
        if (value == null) {
            return false;
        }
        try {
            this.field().set(this.instance(), value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @ApiStatus.Internal
    private static <T> T[] castArray(Object[] array, Class<T> clazz) {
        Object[] newArray = (Object[])Array.newInstance(clazz, array.length);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = clazz.cast(array[i]);
        }
        return newArray;
    }
}

