/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.range;

import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.client.components.options.range.OptionRange;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public record DecimalOptionRange(DoubleConsumer setter, DoubleSupplier getter, double min, double max, double step) implements OptionRange
{
    public static DecimalOptionRange of(ResourcefulConfigValueEntry entry) {
        return switch (entry.type()) {
            case EntryType.FLOAT -> DecimalOptionRange.ofFloat(entry);
            case EntryType.DOUBLE -> DecimalOptionRange.ofDouble(entry);
            default -> throw new IllegalStateException("Unexpected value: " + entry.type());
        };
    }

    private static DecimalOptionRange ofFloat(ResourcefulConfigValueEntry entry) {
        DoubleConsumer setter = value -> entry.setFloat((float)value);
        DoubleSupplier getter = entry::getFloat;
        EntryData options = entry.options();
        if (options.hasRange()) {
            return new DecimalOptionRange(setter, getter, options.min(), options.max(), 1.0);
        }
        return new DecimalOptionRange(setter, getter, 1.4E-45f, 3.4028234663852886E38, 0.0);
    }

    private static DecimalOptionRange ofDouble(ResourcefulConfigValueEntry entry) {
        DoubleConsumer setter = entry::setDouble;
        DoubleSupplier getter = entry::getDouble;
        EntryData options = entry.options();
        if (options.hasRange()) {
            return new DecimalOptionRange(setter, getter, options.min(), options.max(), 1.0);
        }
        return new DecimalOptionRange(setter, getter, Double.MIN_VALUE, Double.MAX_VALUE, 0.0);
    }

    @Override
    public class_2561 toComponent() {
        return class_2561.method_43470((String)String.format("%.2f", this.getter.getAsDouble()));
    }

    @Override
    public class_2561 minComponent() {
        return class_2561.method_43470((String)String.format("%.2f", this.min));
    }

    @Override
    public class_2561 maxComponent() {
        return class_2561.method_43470((String)String.format("%.2f", this.max));
    }

    @Override
    public void setPercent(double value) {
        this.setter.accept(class_3532.method_15390((double)this.min, (double)this.max, (double)value));
    }

    @Override
    public double getPercent() {
        return (this.getter.getAsDouble() - this.min) / (this.max - this.min);
    }

    @Override
    public double getStepPercent() {
        return this.step / (this.max - this.min);
    }

    @Override
    public boolean hasRange() {
        return this.step != 0.0;
    }
}

