/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.loader;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigObjectEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncArray;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncElement;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncObject;
import com.teamresourceful.resourcefulconfig.common.jsonc.JsoncPrimitive;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class Writer {
    public static JsoncObject save(ResourcefulConfig config) {
        JsoncObject object = new JsoncObject();
        Writer.writeEntries(config.entries(), object);
        Writer.writeCategories(config.categories(), object);
        return object;
    }

    private static void writeCategories(LinkedHashMap<String, ResourcefulConfig> entries, JsoncObject object) {
        entries.forEach((key, value) -> {
            JsoncObject category = new JsoncObject();
            Writer.writeEntries(value.entries(), category);
            Writer.writeCategories(value.categories(), category);
            object.add((String)key, category);
        });
    }

    private static JsoncObject writeEntries(LinkedHashMap<String, ResourcefulConfigEntry> entries, JsoncObject object) {
        entries.forEach((key, value) -> {
            JsoncElement element = Writer.toElement(value);
            if (element == null) {
                return;
            }
            element.comment(Writer.getComments(value));
            object.add((String)key, element);
        });
        return object;
    }

    private static JsoncElement toElement(ResourcefulConfigEntry entry) {
        if (entry instanceof ResourcefulConfigObjectEntry) {
            ResourcefulConfigObjectEntry objectEntry = (ResourcefulConfigObjectEntry)entry;
            return Writer.writeEntries(objectEntry.entries(), new JsoncObject());
        }
        if (entry instanceof ResourcefulConfigValueEntry) {
            ResourcefulConfigValueEntry valueEntry = (ResourcefulConfigValueEntry)entry;
            return Writer.valueOf(valueEntry.get());
        }
        return null;
    }

    private static JsoncElement valueOf(Object value) {
        if (value == null) {
            throw new NullPointerException("Config value cannot be null!");
        }
        if (value instanceof String) {
            String string = (String)value;
            return new JsoncPrimitive(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return new JsoncPrimitive(number);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return new JsoncPrimitive(bool);
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return new JsoncPrimitive(enumValue.name());
        }
        if (value.getClass().isArray()) {
            JsoncArray array = new JsoncArray();
            ParsingUtils.forEach(value, o -> array.add(Writer.valueOf(o)));
            return array;
        }
        return null;
    }

    private static String getComments(ResourcefulConfigEntry entry) {
        ArrayList<Object> comments = new ArrayList<Object>();
        EntryData options = entry.options();
        if (entry instanceof ResourcefulConfigValueEntry) {
            ResourcefulConfigValueEntry valueEntry = (ResourcefulConfigValueEntry)entry;
            if (options.hasRange()) {
                DecimalFormat format = new DecimalFormat();
                format.setGroupingUsed(false);
                format.setMaximumFractionDigits(340);
                comments.add("Range: " + format.format(options.min()) + " - " + format.format(options.max()));
            }
            if (options.hasRegex()) {
                comments.add("Regex: " + options.regex().pattern());
            }
            if (options.isMultiline() && entry.type() == EntryType.STRING) {
                comments.add("[Allows newlines]");
            }
            if (entry.type() == EntryType.ENUM) {
                ArrayList<String> enumNames = new ArrayList<String>();
                for (Enum enumConstant : (Enum[])valueEntry.objectType().getEnumConstants()) {
                    enumNames.add(enumConstant.name());
                }
                comments.add("Valid Values: " + String.join((CharSequence)", ", enumNames));
            }
        }
        if (comments.isEmpty() && entry.type() != EntryType.BOOLEAN && entry.type() != EntryType.STRING && entry.type() != EntryType.OBJECT) {
            comments.add("Type: " + entry.type().name().charAt(0) + entry.type().name().substring(1).toLowerCase());
        }
        options.comment().ifPresent((comment, translation) -> comments.add(0, comment));
        return String.join((CharSequence)"\n", comments);
    }
}

