/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.web.server.paths;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.info.ResourcefulConfigInfo;
import com.teamresourceful.resourcefulconfig.api.types.info.ResourcefulConfigLink;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.common.config.Configurations;
import com.teamresourceful.resourcefulconfig.web.info.UserJwtPayload;
import com.teamresourceful.resourcefulconfig.web.server.paths.BasePath;
import com.teamresourceful.resourcefulconfig.web.utils.WebServerUtils;
import com.teamresourceful.resourcefulconfig.web.utils.WebVerifier;
import java.io.IOException;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record GetConfigPath(WebVerifier verifier) implements BasePath
{
    @Override
    public void handleCall(HttpExchange exchange, UserJwtPayload payload) throws IOException {
        String query = WebServerUtils.getQueryValue(exchange, "id");
        if (query != null) {
            ResourcefulConfig config = Configurations.INSTANCE.configs().get(query);
            if (config != null && !config.info().isHidden()) {
                JsonObject json = GetConfigPath.createWebConfig(config);
                WebServerUtils.send(exchange, 200, "application/json", json.toString().getBytes());
            } else {
                WebServerUtils.send(exchange, 400, null, new byte[0]);
            }
        } else {
            WebServerUtils.send(exchange, 400, null, new byte[0]);
        }
    }

    @Override
    public String method() {
        return "GET";
    }

    private static JsonObject createWebConfig(ResourcefulConfig config) {
        ResourcefulConfigInfo info = config.info();
        JsonObject json = GetConfigPath.createWebConfigData(config);
        json.addProperty("icon", info.icon());
        json.addProperty("title", info.title().toLocalizedString());
        json.addProperty("description", info.description().toLocalizedString());
        JsonArray links = new JsonArray();
        for (ResourcefulConfigLink link : info.links()) {
            links.add(link.toJson());
        }
        json.add("links", (JsonElement)links);
        return json;
    }

    private static JsonObject createWebConfigData(ResourcefulConfig config) {
        JsonObject json = new JsonObject();
        json.add("entries", (JsonElement)GetConfigPath.createEntries(config));
        JsonArray categories = new JsonArray();
        config.categories().forEach((id, category) -> {
            ResourcefulConfigInfo info = category.info();
            if (!info.isHidden()) {
                JsonObject categoryJson = GetConfigPath.createWebConfigData(category);
                categoryJson.addProperty("id", id);
                categoryJson.addProperty("icon", info.icon());
                categoryJson.addProperty("title", info.title().toLocalizedString());
                categories.add((JsonElement)categoryJson);
            }
        });
        json.add("categories", (JsonElement)categories);
        return json;
    }

    private static JsonArray createEntries(ResourcefulConfig config) {
        JsonArray array = new JsonArray();
        config.entries().forEach((id, entry) -> {
            JsonObject json = new JsonObject();
            if (!(entry instanceof ResourcefulConfigValueEntry)) {
                return;
            }
            ResourcefulConfigValueEntry valueEntry = (ResourcefulConfigValueEntry)entry;
            if (valueEntry.objectType().isArray()) {
                return;
            }
            switch (entry.type()) {
                case BYTE: {
                    GetConfigPath.createNumber(json, valueEntry, ResourcefulConfigValueEntry::getByte);
                    break;
                }
                case SHORT: {
                    GetConfigPath.createNumber(json, valueEntry, ResourcefulConfigValueEntry::getShort);
                    break;
                }
                case INTEGER: {
                    GetConfigPath.createNumber(json, valueEntry, ResourcefulConfigValueEntry::getInt);
                    break;
                }
                case LONG: {
                    GetConfigPath.createNumber(json, valueEntry, ResourcefulConfigValueEntry::getLong);
                    break;
                }
                case FLOAT: {
                    GetConfigPath.createNumber(json, valueEntry, ResourcefulConfigValueEntry::getFloat);
                    break;
                }
                case DOUBLE: {
                    GetConfigPath.createNumber(json, valueEntry, ResourcefulConfigValueEntry::getDouble);
                    break;
                }
                case ENUM: {
                    Enum def = (Enum)valueEntry.defaultValue();
                    json.addProperty("type", "dropdown");
                    json.addProperty("current", valueEntry.getEnum().name());
                    json.addProperty("default", def.name());
                    JsonArray options = new JsonArray();
                    for (Enum<?> e : GetConfigPath.getEnumConstants(valueEntry.objectType())) {
                        options.add(e.name());
                    }
                    json.add("options", (JsonElement)options);
                    break;
                }
                case BOOLEAN: {
                    json.addProperty("type", "toggle");
                    json.addProperty("current", Boolean.valueOf(valueEntry.getBoolean()));
                    json.addProperty("default", valueEntry.defaultOrElse(false));
                    break;
                }
                case STRING: {
                    json.addProperty("type", valueEntry.options().isMultiline() ? "large-textbox" : "small-textbox");
                    json.addProperty("current", valueEntry.getString());
                    json.addProperty("default", valueEntry.defaultOrElse(""));
                }
            }
            json.addProperty("id", id);
            json.addProperty("title", valueEntry.options().title().toLocalizedString());
            json.addProperty("description", valueEntry.options().comment().toLocalizedString());
            array.add((JsonElement)json);
        });
        return array;
    }

    private static <T extends Number> void createNumber(JsonObject json, ResourcefulConfigValueEntry entry, Function<ResourcefulConfigValueEntry, T> getter) {
        EntryData options = entry.options();
        Number def = entry.defaultOrElse(WebServerUtils.ZERO);
        Number current = (Number)getter.apply(entry);
        json.addProperty("type", options.hasRange() ? "range" : "number");
        json.addProperty("decimals", Boolean.valueOf(def instanceof Float || def instanceof Double));
        json.addProperty("current", current);
        json.addProperty("default", def);
        if (options.hasRange()) {
            json.addProperty("min", (Number)options.min());
            json.addProperty("max", (Number)options.max());
            json.addProperty("step", (Number)1);
        }
    }

    private static Enum<?>[] getEnumConstants(Class<?> clazz) {
        return (Enum[])clazz.getEnumConstants();
    }
}

