/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_1928;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7417;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractLanguageProvider
implements class_2405 {
    protected final String languageCode;
    protected final String modId;
    protected final class_7784.class_7489 pathProvider;

    public AbstractLanguageProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String languageCode, DataProviderContext context) {
        this(languageCode, context.getModId(), context.getPackOutput());
    }

    public AbstractLanguageProvider(String modId, class_7784 packOutput) {
        this("en_us", modId, packOutput);
    }

    public AbstractLanguageProvider(String languageCode, String modId, class_7784 packOutput) {
        this.languageCode = languageCode;
        this.modId = modId;
        this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "lang");
    }

    public abstract void addTranslations(TranslationBuilder var1);

    public CompletableFuture<?> method_10319(class_7403 writer) {
        JsonObject jsonObject = new JsonObject();
        this.addTranslations((key, value) -> {
            Objects.requireNonNull(key, "key is null");
            Objects.requireNonNull(value, "value is null");
            if (jsonObject.has(key)) {
                throw new IllegalStateException("Duplicate translation key found: " + key);
            }
            jsonObject.addProperty(key, value);
        });
        return class_2405.method_10320((class_7403)writer, (JsonElement)jsonObject, (Path)this.pathProvider.method_44107(new class_2960(this.modId, this.languageCode)));
    }

    public String method_10321() {
        return "Language (%s)".formatted(this.languageCode);
    }

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface TranslationBuilder {
        public void add(String var1, String var2);

        default public void add(String key, String additionalKey, String value) {
            Objects.requireNonNull(additionalKey, "additional key is null");
            this.add(key + (String)(additionalKey.isEmpty() ? "" : "." + additionalKey), value);
        }

        default public void add(class_2960 identifier, String value) {
            this.add(identifier, "", value);
        }

        default public void add(class_2960 identifier, String additionalKey, String value) {
            Objects.requireNonNull(identifier, "identifier is null");
            this.add(identifier.method_42094(), additionalKey, value);
        }

        default public void add(String registry, class_6880<?> holder, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(holder, "holder is null");
            this.add(registry, (class_5321)holder.method_40230().orElseThrow(), value);
        }

        default public void add(String registry, class_5321<?> resourceKey, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(resourceKey, "resource key is null");
            this.add(registry, resourceKey.method_29177(), value);
        }

        default public void add(String registry, class_2960 resourceLocation, String value) {
            Objects.requireNonNull(registry, "registry is null");
            Objects.requireNonNull(resourceLocation, "resource location is null");
            this.add(class_156.method_646((String)registry, (class_2960)resourceLocation), value);
        }

        default public void add(class_2248 block, String value) {
            this.add(block, "", value);
        }

        default public void add(class_2248 block, String additionalKey, String value) {
            Objects.requireNonNull(block, "block is null");
            this.add(block.method_9539(), additionalKey, value);
        }

        default public void addSpawnEgg(class_1792 item, String value) {
            if (!(item instanceof class_1826)) {
                throw new IllegalArgumentException("Unsupported item: " + item);
            }
            this.add(item, value + " Spawn Egg");
        }

        default public void add(class_1792 item, String value) {
            this.add(item, "", value);
        }

        default public void add(class_1792 item, String additionalKey, String value) {
            Objects.requireNonNull(item, "item is null");
            this.add(item.method_7876(), additionalKey, value);
        }

        default public void add(class_1887 enchantment, String value) {
            this.add(enchantment, "", value);
        }

        default public void add(class_1887 enchantment, String additionalKey, String value) {
            Objects.requireNonNull(enchantment, "enchantment is null");
            this.add(enchantment.method_8184(), additionalKey, value);
        }

        default public void add(class_1291 mobEffect, String value) {
            this.add(mobEffect, "", value);
        }

        default public void add(class_1291 mobEffect, String additionalKey, String value) {
            Objects.requireNonNull(mobEffect, "mob effect is null");
            this.add(mobEffect.method_5567(), additionalKey, value);
        }

        default public void add(class_1299<?> entityType, String value) {
            this.add(entityType, "", value);
        }

        default public void add(class_1299<?> entityType, String additionalKey, String value) {
            Objects.requireNonNull(entityType, "entity type is null");
            this.add(entityType.method_5882(), additionalKey, value);
        }

        default public void add(class_1320 attribute, String value) {
            this.add(attribute, "", value);
        }

        default public void add(class_1320 attribute, String additionalKey, String value) {
            Objects.requireNonNull(attribute, "attribute is null");
            this.add(attribute.method_26830(), additionalKey, value);
        }

        default public void add(class_3448<?> statType, String value) {
            this.add(statType, "", value);
        }

        default public void add(class_3448<?> statType, String additionalKey, String value) {
            Objects.requireNonNull(statType, "stat type is null");
            Objects.requireNonNull(statType.method_30739(), "component is null");
            class_7417 class_74172 = statType.method_30739().method_10851();
            if (!(class_74172 instanceof class_2588)) {
                throw new IllegalArgumentException("Unsupported component: " + statType.method_30739());
            }
            class_2588 contents = (class_2588)class_74172;
            this.add(contents.method_11022(), value);
        }

        default public void add(class_1928.class_4313<?> gameRule, String value) {
            this.add(gameRule, "", value);
        }

        default public void addGameRuleDescription(class_1928.class_4313<?> gameRule, String value) {
            this.add(gameRule, "description", value);
        }

        default public void add(class_1928.class_4313<?> gameRule, String additionalKey, String value) {
            Objects.requireNonNull(gameRule, "game rule is null");
            this.add(gameRule.method_27334(), additionalKey, value);
        }

        default public void add(class_1842 potion, String value) {
            Objects.requireNonNull(potion, "potion is null");
            String potionName = potion.method_8051("");
            this.add("item.minecraft.tipped_arrow.effect." + potionName, "Arrow of " + value);
            this.add("item.minecraft.potion.effect." + potionName, "Potion of " + value);
            this.add("item.minecraft.splash_potion.effect." + potionName, "Splash Potion of " + value);
            this.add("item.minecraft.lingering_potion.effect." + potionName, "Lingering Potion of " + value);
        }

        default public void add(class_3414 soundEvent, String value) {
            Objects.requireNonNull(soundEvent, "sound event is null");
            this.add("subtitles." + soundEvent.method_14833().method_12832(), value);
        }

        default public void add(class_304 keyMapping, String value) {
            Objects.requireNonNull(keyMapping, "key mapping is null");
            this.add(keyMapping.method_1431(), value);
        }

        default public void addKeyCategory(String modId, String value) {
            this.add("key.categories." + modId, value);
        }

        default public void addCreativeModeTab(String modId, String value) {
            this.addCreativeModeTab(modId, "main", value);
        }

        default public void addCreativeModeTab(String modId, String tabId, String value) {
            Objects.requireNonNull(modId, "mod id is null");
            Objects.requireNonNull(tabId, "tab id is null");
            this.addCreativeModeTab(new class_2960(modId, tabId), value);
        }

        default public void addCreativeModeTab(class_2960 identifier, String value) {
            Objects.requireNonNull(identifier, "identifier is null");
            this.addCreativeModeTab((class_5321<class_1761>)class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)identifier), value);
        }

        default public void addCreativeModeTab(class_5321<class_1761> resourceKey, String value) {
            Objects.requireNonNull(resourceKey, "resource key is null");
            this.add((class_1761)class_7923.field_44687.method_29107(resourceKey), value);
        }

        default public void add(class_1761 tab, String value) {
            Objects.requireNonNull(tab, "tab is null");
            this.add(tab.method_7737(), value);
        }

        default public void add(class_2561 component, String value) {
            Objects.requireNonNull(component, "component is null");
            class_7417 class_74172 = component.method_10851();
            if (!(class_74172 instanceof class_2588)) {
                throw new IllegalArgumentException("Unsupported component: " + component);
            }
            class_2588 contents = (class_2588)class_74172;
            this.add(contents.method_11022(), value);
        }

        default public void addGenericDamageType(class_5321<class_8110> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.method_29177().method_12832(), value);
        }

        default public void addPlayerDamageType(class_5321<class_8110> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.method_29177().method_12832() + ".player", value);
        }

        default public void addItemDamageType(class_5321<class_8110> damageType, String value) {
            Objects.requireNonNull(damageType, "damage type is null");
            this.add("death.attack." + damageType.method_29177().method_12832() + ".item", value);
        }
    }
}

