/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.client.key;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import fuzs.puzzleslib.api.client.event.v1.InputEvents;
import fuzs.puzzleslib.api.client.key.v1.KeyActivationContext;
import fuzs.puzzleslib.api.client.key.v1.KeyMappingHelper;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_6599;

public final class FabricKeyMappingHelper
implements KeyMappingHelper {
    private static final Multimap<KeyActivationContext, class_304> KEY_MAPPINGS_BY_ACTIVATION = Multimaps.newListMultimap((Map)Maps.newEnumMap(KeyActivationContext.class), Lists::newArrayList);
    private static final Map<class_304, KeyActivationContext> KEY_MAPPINGS_TO_ACTIVATION = Maps.newIdentityHashMap();

    public FabricKeyMappingHelper() {
        ClientLifecycleEvents.CLIENT_STARTED.register(minecraft -> {
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1894, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1913, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1881, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1849, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1903, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1832, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1867, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1886, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1890, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1907, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1845, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1824, KeyActivationContext.GAME);
            KEY_MAPPINGS_TO_ACTIVATION.put(minecraft.field_1690.field_1816, KeyActivationContext.GAME);
        });
        LinkedHashMap keys = Maps.newLinkedHashMap();
        InputEvents.BEFORE_KEY_ACTION.register(EventPhase.LAST, (key, scanCode, action, modifiers) -> {
            this.clearKeys(keys, keyMapping -> keyMapping.method_1417(key, scanCode), () -> class_3675.method_15985((int)key, (int)scanCode));
            return EventResult.PASS;
        });
        InputEvents.AFTER_KEY_ACTION.register(EventPhase.FIRST, (key, scanCode, action, modifiers) -> this.setOriginalKeys(keys));
        InputEvents.BEFORE_MOUSE_ACTION.register(EventPhase.LAST, (button, action, modifiers) -> {
            this.clearKeys(keys, keyMapping -> keyMapping.method_1433(button), () -> class_3675.class_307.field_1672.method_1447(button));
            return EventResult.PASS;
        });
        InputEvents.AFTER_MOUSE_ACTION.register(EventPhase.FIRST, (button, action, modifiers) -> this.setOriginalKeys(keys));
    }

    public static void setKeyActivationContext(class_304 keyMapping, KeyActivationContext keyActivationContext) {
        KEY_MAPPINGS_BY_ACTIVATION.put((Object)keyActivationContext, (Object)keyMapping);
        KEY_MAPPINGS_TO_ACTIVATION.put(keyMapping, keyActivationContext);
    }

    @Override
    public KeyActivationContext getKeyActivationContext(class_304 keyMapping) {
        return KEY_MAPPINGS_TO_ACTIVATION.getOrDefault(keyMapping, KeyActivationContext.UNIVERSAL);
    }

    private void clearKeys(Map<class_304, class_3675.class_306> keys, Predicate<class_304> filter, Supplier<class_3675.class_306> key) {
        if (!keys.isEmpty()) {
            return;
        }
        class_437 screen = class_310.method_1551().field_1755;
        if (!(screen instanceof class_6599)) {
            KeyActivationContext inactive = screen != null ? KeyActivationContext.GAME : KeyActivationContext.SCREEN;
            KEY_MAPPINGS_BY_ACTIVATION.get((Object)inactive).forEach(keyMapping -> {
                if (filter.test((class_304)keyMapping)) {
                    keys.put((class_304)keyMapping, (class_3675.class_306)key.get());
                    keyMapping.method_1422(class_3675.field_16237);
                }
            });
        }
    }

    private void setOriginalKeys(Map<class_304, class_3675.class_306> keys) {
        keys.forEach(class_304::method_1422);
        keys.keySet().forEach(keyMapping -> {
            keyMapping.method_23481(false);
            while (keyMapping.method_1436()) {
            }
        });
        keys.clear();
    }
}

