/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.fabric.impl.config;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Unit;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeModConfigEvents;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.impl.config.ConfigDataHolderImpl;
import fuzs.puzzleslib.impl.config.ConfigHolderImpl;
import java.util.Objects;
import java.util.function.Supplier;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public class FabricConfigHolderImpl
extends ConfigHolderImpl {
    public FabricConfigHolderImpl(String modId) {
        super(modId);
    }

    @Override
    protected <T extends ConfigCore> ConfigDataHolderImpl<T> client(Supplier<T> supplier) {
        return new FabricConfigDataHolderImpl<T>(ModConfig.Type.CLIENT, supplier);
    }

    @Override
    protected <T extends ConfigCore> ConfigDataHolderImpl<T> common(Supplier<T> supplier) {
        return new FabricConfigDataHolderImpl<T>(ModConfig.Type.COMMON, supplier);
    }

    @Override
    protected <T extends ConfigCore> ConfigDataHolderImpl<T> server(Supplier<T> supplier) {
        return new FabricConfigDataHolderImpl<T>(ModConfig.Type.SERVER, supplier);
    }

    @Override
    protected void bake(ConfigDataHolderImpl<?> holder, String modId) {
        NeoForgeModConfigEvents.loading((String)modId).register(config -> ((FabricConfigDataHolderImpl)holder).onModConfig(config, true, "Loading"));
        NeoForgeModConfigEvents.reloading((String)modId).register(config -> ((FabricConfigDataHolderImpl)holder).onModConfig(config, true, "Reloading"));
        NeoForgeModConfigEvents.unloading((String)modId).register(config -> ((FabricConfigDataHolderImpl)holder).onModConfig(config, false, "Unloading"));
        ((FabricConfigDataHolderImpl)holder).register(modId);
    }

    private static class FabricConfigDataHolderImpl<T extends ConfigCore>
    extends ConfigDataHolderImpl<T> {
        private final ModConfig.Type configType;
        @Nullable
        private ModConfig modConfig;

        protected FabricConfigDataHolderImpl(ModConfig.Type configType, Supplier<T> supplier) {
            super(configType.extension(), supplier);
            this.configType = configType;
        }

        @Override
        protected Either<Unit, String> findErrorMessage() {
            if (this.modConfig == null) {
                return Either.right((Object)"Mod config instance is missing");
            }
            if (this.modConfig.getConfigData() == null) {
                return Either.right((Object)"Config data is missing");
            }
            return super.findErrorMessage();
        }

        public void onModConfig(ModConfig modConfig, boolean isLoading, String eventType) {
            if (modConfig.getType() == this.configType && (this.modConfig == null || modConfig == this.modConfig)) {
                super.onModConfig(modConfig.getModId(), isLoading, eventType);
            }
        }

        public void register(String modId) {
            Objects.requireNonNull(this.config, "Attempting to register invalid config of type %s".formatted(this.configType.extension()));
            if (this.modConfig != null) {
                throw new IllegalStateException(String.format("Config for type %s has already been registered!", this.configType.extension()));
            }
            this.modConfig = new ModConfig(this.configType, (IConfigSpec)this.buildSpec(), modId, (String)this.fileName.apply(modId));
        }
    }
}

