/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core.resources;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import fuzs.puzzleslib.api.core.v1.resources.NamedReloadListener;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;

public record ForwardingReloadListener(class_2960 identifier, Supplier<Collection<class_3302>> reloadListeners) implements NamedReloadListener
{
    public ForwardingReloadListener(class_2960 identifier, Supplier<Collection<class_3302>> reloadListeners) {
        this.identifier = identifier;
        this.reloadListeners = Suppliers.memoize(() -> ImmutableList.copyOf((Collection)((Collection)reloadListeners.get())));
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.completedFuture(null).thenCompose($ -> {
            Collection<class_3302> reloadListeners = this.reloadListeners.get();
            if (reloadListeners.isEmpty()) {
                throw new IllegalStateException("Reload listeners in %s are empty".formatted(this.identifier));
            }
            return CompletableFuture.allOf((CompletableFuture[])reloadListeners.stream().map(reloadListener -> {
                try {
                    return reloadListener.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
                }
                catch (Exception exception) {
                    PuzzlesLib.LOGGER.error("Unable to reload listener {}", (Object)reloadListener.method_22322(), (Object)exception);
                    return CompletableFuture.completedFuture(null).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0));
                }
            }).toArray(CompletableFuture[]::new));
        });
    }

    @Override
    public String toString() {
        return this.method_22322();
    }
}

