/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.config;

import glitchcore.config.Config;
import glitchcore.network.SyncConfigPacket;
import glitchcore.util.Environment;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class ConfigSync {
    private static Map<String, Config> configs = new HashMap<String, Config>();

    public static void register(Config config) {
        String relative = Environment.getConfigPath().relativize(config.getPath()).toString();
        configs.put(relative, config);
    }

    public static Stream<SyncConfigPacket> createPackets() {
        return configs.entrySet().stream().map(e -> {
            Config config = (Config)e.getValue();
            config.read();
            config.load();
            return new SyncConfigPacket((String)e.getKey(), ((Config)e.getValue()).encode().getBytes(StandardCharsets.UTF_8));
        });
    }

    public static void reload(String path, String toml) {
        Config config = configs.get(path);
        config.parse(toml);
        config.load();
    }
}

