/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.impl;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.impl.OptionGroupImpl;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ConfigCategoryImpl
implements ConfigCategory {
    private final class_2561 name;
    private final ImmutableList<OptionGroup> groups;
    private final class_2561 tooltip;

    public ConfigCategoryImpl(class_2561 name, ImmutableList<OptionGroup> groups2, class_2561 tooltip) {
        this.name = name;
        this.groups = groups2;
        this.tooltip = tooltip;
    }

    @Override
    @NotNull
    public class_2561 name() {
        return this.name;
    }

    @Override
    @NotNull
    public ImmutableList<OptionGroup> groups() {
        return this.groups;
    }

    @Override
    @NotNull
    public class_2561 tooltip() {
        return this.tooltip;
    }

    @ApiStatus.Internal
    public static final class BuilderImpl
    implements ConfigCategory.Builder {
        private class_2561 name;
        private final List<Option<?>> rootOptions = new ArrayList();
        private final RootGroupBuilder rootGroupBuilder = new RootGroupBuilder();
        private final List<OptionGroup> groups = new ArrayList<OptionGroup>();
        private final List<class_2561> tooltipLines = new ArrayList<class_2561>();

        @Override
        public ConfigCategory.Builder name(@NotNull class_2561 name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        @Override
        public ConfigCategory.Builder option(@NotNull Option<?> option) {
            Validate.notNull(option, (String)"`option` must not be null", (Object[])new Object[0]);
            if (option instanceof ListOption) {
                ListOption listOption = (ListOption)option;
                YACLConstants.LOGGER.warn("Adding list option as an option is not supported! Rerouting to group!");
                return this.group(listOption);
            }
            this.rootOptions.add(option);
            return this;
        }

        @Override
        public ConfigCategory.Builder options(@NotNull Collection<? extends Option<?>> options2) {
            Validate.notNull(options2, (String)"`options` must not be null", (Object[])new Object[0]);
            if (options2.stream().anyMatch(ListOption.class::isInstance)) {
                throw new UnsupportedOperationException("List options must not be added as an option but a group!");
            }
            this.rootOptions.addAll(options2);
            return this;
        }

        @Override
        public ConfigCategory.Builder group(@NotNull OptionGroup group) {
            Validate.notNull((Object)group, (String)"`group` must not be null", (Object[])new Object[0]);
            this.groups.add(group);
            return this;
        }

        @Override
        public ConfigCategory.Builder groups(@NotNull Collection<OptionGroup> groups2) {
            Validate.notEmpty(groups2, (String)"`groups` must not be empty", (Object[])new Object[0]);
            this.groups.addAll(groups2);
            return this;
        }

        @Override
        public ConfigCategory.Builder tooltip(class_2561 ... tooltips) {
            Validate.notEmpty((Object[])tooltips, (String)"`tooltips` cannot be empty", (Object[])new Object[0]);
            this.tooltipLines.addAll(List.of(tooltips));
            return this;
        }

        @Override
        public OptionGroup.Builder rootGroupBuilder() {
            return this.rootGroupBuilder;
        }

        @Override
        public ConfigCategory build() {
            Validate.notNull((Object)this.name, (String)"`name` must not be null to build `ConfigCategory`", (Object[])new Object[0]);
            ArrayList<OptionGroup> combinedGroups = new ArrayList<OptionGroup>();
            combinedGroups.add(new OptionGroupImpl(class_5244.field_39003, OptionDescription.EMPTY, ImmutableList.copyOf(this.rootOptions), false, true));
            combinedGroups.addAll(this.groups);
            Validate.notEmpty(combinedGroups, (String)"at least one option must be added to build `ConfigCategory`", (Object[])new Object[0]);
            class_5250 concatenatedTooltip = class_2561.method_43473();
            boolean first = true;
            for (class_2561 line : this.tooltipLines) {
                if (line.method_10851() == class_5244.field_39003.method_10851()) continue;
                if (!first) {
                    concatenatedTooltip.method_27693("\n");
                }
                first = false;
                concatenatedTooltip.method_10852(line);
            }
            return new ConfigCategoryImpl(this.name, (ImmutableList<OptionGroup>)ImmutableList.copyOf(combinedGroups), (class_2561)concatenatedTooltip);
        }

        private class RootGroupBuilder
        implements OptionGroup.Builder {
            private RootGroupBuilder() {
            }

            @Override
            public OptionGroup.Builder name(@NotNull class_2561 name) {
                throw new UnsupportedOperationException("Cannot set name of root group!");
            }

            @Override
            public OptionGroup.Builder description(@NotNull OptionDescription description) {
                throw new UnsupportedOperationException("Cannot set name of root group!");
            }

            @Override
            public OptionGroup.Builder option(@NotNull Option<?> option) {
                BuilderImpl.this.option((Option)option);
                return this;
            }

            @Override
            public OptionGroup.Builder options(@NotNull Collection<? extends Option<?>> options2) {
                BuilderImpl.this.options((Collection)options2);
                return this;
            }

            @Override
            public OptionGroup.Builder collapsed(boolean collapsible) {
                throw new UnsupportedOperationException("Cannot set collapsible of root group!");
            }

            @Override
            public OptionGroup build() {
                throw new UnsupportedOperationException("Cannot build root group!");
            }
        }
    }
}

