/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.menus;

import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModMenuTypes;
import earth.terrarium.chipped.common.registry.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkbenchMenu
extends class_1703 {
    protected final class_1661 inventory;
    protected final class_1937 level;
    private int selectedStackId;
    private class_1799 selectedStack = class_1799.field_8037;
    private class_1799 chosenStack = class_1799.field_8037;
    @Nullable
    private String filter;
    private final List<class_1799> results = new ArrayList<class_1799>();

    public WorkbenchMenu(int containerId, class_1661 inventory) {
        super((class_3917)ModMenuTypes.WORKBENCH.get(), containerId);
        this.inventory = inventory;
        this.level = inventory.field_7546.method_37908();
        this.addPlayerInvSlots();
    }

    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    protected void addPlayerInvSlots() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new InventorySlot((class_1263)this.inventory, j + i * 9 + 9, this.getPlayerInvXOffset() + j * 18, this.getPlayerInvYOffset() + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new InventorySlot((class_1263)this.inventory, i, this.getPlayerInvXOffset() + i * 18, this.getPlayerInvYOffset() + 58));
        }
    }

    public int getPlayerInvXOffset() {
        return 86;
    }

    public int getPlayerInvYOffset() {
        return 167;
    }

    public void method_7593(int slotId, int button, class_1713 clickType, class_1657 player) {
        this.selectStack(slotId);
        super.method_7593(slotId, button, clickType, player);
    }

    public void selectStack(int slotId) {
        if (slotId < 0 || slotId >= this.field_7761.size()) {
            return;
        }
        this.selectedStackId = ((class_1735)this.field_7761.get(slotId)).method_34266();
        this.chosenStack = this.selectedStack = ((class_1735)this.field_7761.get(slotId)).method_7677();
        this.updateResults(this.filter);
    }

    public void updateResults(@Nullable String filter) {
        if (this.selectedStack.method_7960()) {
            return;
        }
        this.filter = filter;
        class_1277 container = new class_1277(new class_1799[]{this.selectedStack});
        this.level.method_8433().method_8132((class_3956)ModRecipeTypes.WORKBENCH.get(), (class_1263)container, this.level).ifPresentOrElse(recipe -> {
            this.results.clear();
            ((ChippedRecipe)recipe.comp_1933()).getResults(container.method_5438(0)).forEach(result -> {
                if (filter == null || class_156.method_51894((String)filter) || result.method_7954().getString().toLowerCase(Locale.ROOT).contains(filter.toLowerCase(Locale.ROOT))) {
                    this.results.add((class_1799)result);
                }
            });
        }, this::reset);
    }

    public void craft(class_1799 stack, boolean replaceAll) {
        if (stack.method_7960()) {
            return;
        }
        boolean canCraft = false;
        for (class_1799 result : this.results) {
            if (!class_1799.method_7984((class_1799)result, (class_1799)stack)) continue;
            canCraft = true;
            break;
        }
        if (!canCraft) {
            return;
        }
        this.inventory.method_5447(this.selectedStackId, stack.method_46651(this.inventory.method_5438(this.selectedStackId).method_7947()));
        if (replaceAll) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                if (!class_1799.method_7984((class_1799)this.inventory.method_5438(i), (class_1799)this.selectedStack)) continue;
                this.inventory.method_5447(i, stack.method_46651(this.inventory.method_5438(i).method_7947()));
            }
        }
        this.reset();
    }

    public void reset() {
        this.selectedStackId = 0;
        this.selectedStack = class_1799.field_8037;
        this.chosenStack = class_1799.field_8037;
        this.results.clear();
    }

    public class_1799 selectedStack() {
        return this.selectedStack;
    }

    public class_1799 chosenStack() {
        return this.chosenStack;
    }

    public void setChosenStack(class_1799 stack) {
        this.chosenStack = stack;
    }

    public List<class_1799> results() {
        return this.results;
    }

    public class_1937 level() {
        return this.level;
    }

    public void setFilter(@Nullable String filter) {
        this.filter = filter;
    }

    private static class InventorySlot
    extends class_1735 {
        public InventorySlot(class_1263 container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean method_7674(class_1657 player) {
            return false;
        }
    }
}

