/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public interface FluidHolder {
    public static final Codec<FluidHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41173.method_39673().fieldOf("fluid").forGetter(FluidHolder::getFluid), (App)Codec.LONG.fieldOf("millibuckets").orElse((Object)1000L).forGetter(fluidHolder -> FluidConstants.toMillibuckets(fluidHolder.getFluidAmount())), (App)class_2487.field_25128.optionalFieldOf("tag").forGetter(fluidHolder -> Optional.ofNullable(fluidHolder.getCompound()))).apply((Applicative)instance, (fluid, millibuckets, compoundTag) -> FluidHolder.of(fluid, FluidConstants.fromMillibuckets(millibuckets), compoundTag.orElse(null))));

    public static FluidHolder of(class_3611 fluid) {
        return FluidHolder.of(fluid, FluidConstants.getBucketAmount());
    }

    public static FluidHolder of(class_3611 fluid, long amount) {
        return FluidHolder.of(fluid, amount, null);
    }

    public static FluidHolder of(class_3611 fluid, long amount, class_2487 tag) {
        return FabricFluidHolder.of(fluid, amount, tag);
    }

    public static FluidHolder ofMillibuckets(class_3611 fluid, long millibuckets, @Nullable class_2487 tag) {
        return FluidHolder.of(fluid, FluidConstants.fromMillibuckets(millibuckets), tag);
    }

    public static FluidHolder ofMillibuckets(class_3611 fluid, long millibuckets) {
        return FluidHolder.of(fluid, FluidConstants.fromMillibuckets(millibuckets), null);
    }

    public static FluidHolder fromCompound(class_2487 tag) {
        FluidHolder fluid = FluidHolder.of(class_3612.field_15906, 0L);
        fluid.deserialize(tag);
        return fluid;
    }

    public static FluidHolder empty() {
        return FabricFluidHolder.empty();
    }

    default public void writeToBuffer(class_2540 buffer) {
        buffer.method_37435(Optional.ofNullable(this.isEmpty() ? null : this), (friendlyByteBuf, fluid) -> {
            friendlyByteBuf.method_10804(class_7923.field_41173.method_10206((Object)fluid.getFluid()));
            friendlyByteBuf.method_10791(fluid.getFluidAmount());
            friendlyByteBuf.method_10794((class_2520)fluid.getCompound());
        });
    }

    public static FluidHolder readFromBuffer(class_2540 buffer) {
        return buffer.method_37436(friendlyByteBuf -> {
            class_3611 fluid = (class_3611)class_7923.field_41173.method_10200(friendlyByteBuf.method_10816());
            long amount = friendlyByteBuf.method_10792();
            class_2487 tag = friendlyByteBuf.method_10798();
            return FluidHolder.of(fluid, amount, tag);
        }).orElse(FluidHolder.empty());
    }

    public class_3611 getFluid();

    public void setFluid(class_3611 var1);

    public long getFluidAmount();

    default public long getMillibuckets() {
        return FluidConstants.toMillibuckets(this.getFluidAmount());
    }

    public void setAmount(long var1);

    public class_2487 getCompound();

    public void setCompound(class_2487 var1);

    public boolean isEmpty();

    public boolean matches(FluidHolder var1);

    public FluidHolder copyHolder();

    public class_2487 serialize();

    public void deserialize(class_2487 var1);

    default public FluidHolder copyWithAmount(long amount) {
        FluidHolder copy = this.copyHolder();
        if (!copy.isEmpty()) {
            copy.setAmount(amount);
        }
        return copy;
    }

    default public class_6880<class_3611> getFluidHolder() {
        return this.getFluid().method_40178();
    }

    default public boolean is(class_6862<class_3611> tagKey) {
        return this.getFluid().method_15791(tagKey);
    }

    default public boolean is(class_3611 fluid) {
        return this.getFluid() == fluid;
    }

    default public boolean is(Predicate<class_6880<class_3611>> predicate) {
        return predicate.test(this.getFluidHolder());
    }

    default public boolean is(class_6880<class_3611> fluid) {
        return this.getFluidHolder() == fluid;
    }
}

