/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.item.impl;

import earth.terrarium.botarium.common.item.base.ItemContainer;
import earth.terrarium.botarium.common.item.base.ItemContainerExtras;
import earth.terrarium.botarium.common.item.base.ItemSnapshot;
import earth.terrarium.botarium.util.Serializable;
import earth.terrarium.botarium.util.Snapshotable;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;

public class SimpleItemContainer
implements ItemContainer,
ItemContainerExtras,
Serializable,
Snapshotable<ItemSnapshot> {
    private final class_2371<class_1799> stacks;
    private Runnable onUpdate = () -> {};

    public SimpleItemContainer(int capacity) {
        this.stacks = class_2371.method_10213((int)capacity, (Object)class_1799.field_8037);
    }

    public SimpleItemContainer(int capacity, class_1799 stack) {
        this(capacity);
        this.onUpdate = () -> this.serialize(stack.method_7948());
        this.deserialize(stack.method_7948());
    }

    public SimpleItemContainer(int capacity, class_1937 level, class_2338 blockPos) {
        this(capacity);
        this.onUpdate = () -> {
            class_2586 blockEntity;
            if (level != null && (blockEntity = level.method_8321(blockPos)) != null) {
                blockEntity.method_5431();
            }
        };
    }

    public SimpleItemContainer(int capacity, class_2586 blockEntity) {
        this(capacity);
        this.onUpdate = () -> ((class_2586)blockEntity).method_5431();
    }

    public SimpleItemContainer(int capacity, Runnable onUpdate) {
        this(capacity);
        this.onUpdate = onUpdate;
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        return (class_1799)this.stacks.get(slot);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getStackInSlot(slot).method_7914();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return true;
    }

    @Override
    @NotNull
    public class_1799 insertItem(@NotNull class_1799 stack, boolean simulate) {
        if (stack.method_7960() || !this.isItemValid(0, stack)) {
            return class_1799.field_8037;
        }
        int insertedAmount = 0;
        class_1799 initial = stack.method_7972();
        for (int i = 0; i < this.stacks.size(); ++i) {
            stack = stack.method_46651(stack.method_7947() - (insertedAmount += this.insertIntoSlot(i, stack, simulate).method_7947()));
            if (insertedAmount >= initial.method_7947()) break;
        }
        return insertedAmount == 0 ? class_1799.field_8037 : initial.method_46651(insertedAmount);
    }

    @Override
    @NotNull
    public class_1799 insertIntoSlot(int slot, @NotNull class_1799 stack, boolean simulate) {
        int amount;
        if (stack.method_7960() || !this.isItemValid(slot, stack)) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = ((class_1799)this.stacks.get(slot)).method_7972();
        if (itemStack.method_7960()) {
            int amount2 = Math.min(stack.method_7947(), this.getSlotLimit(slot));
            if (!simulate) {
                this.stacks.set(slot, (Object)stack.method_46651(amount2));
            }
            return stack.method_46651(amount2);
        }
        if (class_1799.method_31577((class_1799)stack, (class_1799)itemStack) && (amount = Math.min(stack.method_7947(), this.getSlotLimit(slot) - itemStack.method_7947())) > 0) {
            if (!simulate) {
                itemStack.method_7933(amount);
                this.stacks.set(slot, (Object)itemStack);
            }
            return stack.method_46651(amount);
        }
        return class_1799.field_8037;
    }

    @Override
    @NotNull
    public class_1799 extractItem(int amount, boolean simulate) {
        class_1799 extracted = class_1799.field_8037;
        for (int i = 0; i < this.stacks.size(); ++i) {
            class_1799 stack = (class_1799)this.stacks.get(i);
            if (stack.method_7960()) continue;
            int toExtract = Math.min(amount - extracted.method_7947(), stack.method_7947());
            if (extracted.method_7960()) {
                extracted = stack.method_46651(toExtract);
            } else if (class_1799.method_31577((class_1799)extracted, (class_1799)stack)) {
                extracted.method_7933(toExtract);
            }
            if (!simulate) {
                stack.method_7934(toExtract);
                this.stacks.set(i, (Object)stack);
            }
            if (extracted.method_7947() >= amount) break;
        }
        return extracted;
    }

    @Override
    @NotNull
    public class_1799 extractFromSlot(int slot, int amount, boolean simulate) {
        class_1799 stack = (class_1799)this.stacks.get(slot);
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        int toExtract = Math.min(amount, stack.method_7947());
        class_1799 extracted = stack.method_46651(toExtract);
        if (!simulate) {
            this.stacks.set(slot, (Object)((class_1799)this.stacks.get(slot)).method_46651(stack.method_7947() - toExtract));
        }
        return extracted;
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public void method_5448() {
        this.stacks.clear();
    }

    @Override
    public void deserialize(class_2487 nbt) {
        class_1262.method_5429((class_2487)nbt, this.stacks);
    }

    @Override
    public class_2487 serialize(class_2487 nbt) {
        return class_1262.method_5426((class_2487)nbt, this.stacks);
    }

    @Override
    public SimpleItemSnapshot createSnapshot() {
        return new SimpleItemSnapshot();
    }

    @Override
    public void update() {
        this.onUpdate.run();
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        this.stacks.set(slot, (Object)stack);
    }

    public class SimpleItemSnapshot
    implements ItemSnapshot {
        class_2487 tag;

        public SimpleItemSnapshot() {
            this.tag = SimpleItemContainer.this.serialize(new class_2487());
        }

        @Override
        public void loadSnapshot() {
            SimpleItemContainer.this.stacks.clear();
            SimpleItemContainer.this.deserialize(this.tag);
        }
    }
}

