/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergySnapshot;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.fabric.ItemStackStorage;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public record PlatformItemEnergyManager(ItemStackHolder holder, ContainerItemContext context, EnergyStorage energy) implements EnergyContainer
{
    @Nullable
    public static PlatformItemEnergyManager of(ItemStackHolder stack) {
        ContainerItemContext context = ItemStackStorage.of(stack.getStack());
        EnergyStorage fabricEnergy = (EnergyStorage)EnergyStorage.ITEM.find(stack.getStack(), (Object)context);
        return fabricEnergy == null ? null : new PlatformItemEnergyManager(stack, context, fabricEnergy);
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        try (Transaction txn = Transaction.openOuter();){
            long insert = this.energy.insert(maxAmount, (TransactionContext)txn);
            if (simulate) {
                txn.abort();
            } else {
                txn.commit();
                this.holder.setStack(this.context.getItemVariant().toStack());
            }
            long l = insert;
            return l;
        }
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        try (Transaction txn = Transaction.openOuter();){
            long extract = this.energy.extract(maxAmount, (TransactionContext)txn);
            if (simulate) {
                txn.abort();
            } else {
                txn.commit();
                this.holder.setStack(this.context.getItemVariant().toStack());
            }
            long l = extract;
            return l;
        }
    }

    @Override
    public void setEnergy(long energy) {
        try (Transaction txn = Transaction.openOuter();){
            if (energy > this.energy.getAmount()) {
                this.energy.insert(energy - this.energy.getAmount(), (TransactionContext)txn);
            } else if (energy < this.energy.getAmount()) {
                this.energy.extract(this.energy.getAmount() - energy, (TransactionContext)txn);
            }
            txn.commit();
            this.holder.setStack(this.context.getItemVariant().toStack());
        }
    }

    @Override
    public long getStoredEnergy() {
        return this.energy.getAmount();
    }

    @Override
    public long getMaxCapacity() {
        return this.energy.getCapacity();
    }

    @Override
    public long maxInsert() {
        return this.energy.getCapacity();
    }

    @Override
    public long maxExtract() {
        return this.energy.getCapacity();
    }

    @Override
    public boolean allowsInsertion() {
        return this.energy.supportsInsertion();
    }

    @Override
    public boolean allowsExtraction() {
        return this.energy.supportsExtraction();
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    @Override
    public void deserialize(class_2487 nbt) {
    }

    @Override
    public class_2487 serialize(class_2487 nbt) {
        return nbt;
    }

    public void method_5448() {
        try (Transaction txn = Transaction.openOuter();){
            this.energy.extract(this.energy.getAmount(), (TransactionContext)txn);
            txn.commit();
            this.holder.setStack(this.context.getItemVariant().toStack());
        }
    }
}

