/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.holder.ManualSyncing;
import earth.terrarium.botarium.fabric.fluid.storage.ExtendedFluidContainer;
import earth.terrarium.botarium.fabric.fluid.storage.SingleFluidSlot;
import earth.terrarium.botarium.util.Updatable;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;

public class FabricBlockFluidContainer<T extends FluidContainer & Updatable>
extends ExtendedFluidContainer
implements Storage<FluidVariant>,
ManualSyncing {
    protected final T container;

    public FabricBlockFluidContainer(T container) {
        this.container = container;
    }

    public boolean supportsInsertion() {
        return this.container.allowsInsertion();
    }

    public boolean supportsExtraction() {
        return this.container.allowsExtraction();
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), false);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), false).getFluidAmount();
    }

    @NotNull
    public Iterator<StorageView<FluidVariant>> iterator() {
        return new Iterator<StorageView<FluidVariant>>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FabricBlockFluidContainer.this.container.getSize();
            }

            @Override
            public StorageView<FluidVariant> next() {
                return new SingleFluidSlot(FabricBlockFluidContainer.this, this.index++);
            }
        };
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }

    @Override
    public void onFinalCommit() {
        ((Updatable)this.container).update();
    }
}

