/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.fluid.storage;

import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.fabric.fluid.holder.FabricFluidHolder;
import earth.terrarium.botarium.fabric.fluid.storage.ExtendedFluidContainer;
import earth.terrarium.botarium.fabric.fluid.storage.SingleItemFluidSlot;
import earth.terrarium.botarium.util.Updatable;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class FabricItemFluidContainer<T extends ItemFluidContainer & Updatable>
extends ExtendedFluidContainer
implements Storage<FluidVariant> {
    protected final T container;
    private final ContainerItemContext ctx;

    public FabricItemFluidContainer(ContainerItemContext ctx, T container) {
        this.container = container;
        this.ctx = ctx;
        class_2487 nbt = ctx.getItemVariant().getNbt();
        if (nbt != null) {
            container.deserialize(nbt);
        }
    }

    public boolean supportsInsertion() {
        return this.container.allowsInsertion();
    }

    public boolean supportsExtraction() {
        return this.container.allowsExtraction();
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long inserted = this.container.insertFluid(FabricFluidHolder.of(resource, maxAmount), false);
        this.setChanged(transaction);
        return inserted;
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long extracted = this.container.extractFluid(FabricFluidHolder.of(resource, maxAmount), false).getFluidAmount();
        this.setChanged(transaction);
        return extracted;
    }

    @NotNull
    public Iterator<StorageView<FluidVariant>> iterator() {
        return new Iterator<StorageView<FluidVariant>>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FabricItemFluidContainer.this.container.getSize();
            }

            @Override
            public StorageView<FluidVariant> next() {
                return new SingleItemFluidSlot(FabricItemFluidContainer.this, this.index++);
            }
        };
    }

    public void setChanged(TransactionContext transaction) {
        class_1799 stack = this.ctx.getItemVariant().toStack();
        this.container.serialize(stack.method_7948());
        this.ctx.exchange(ItemVariant.of((class_1799)stack), this.ctx.getAmount(), transaction);
    }

    @Override
    public void onFinalCommit() {
        ((Updatable)this.container).update();
    }

    @Override
    public FluidSnapshot createSnapshot() {
        return this.container.createSnapshot();
    }

    @Override
    public void readSnapshot(FluidSnapshot snapshot) {
        this.container.readSnapshot(snapshot);
    }
}

