/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.item;

import earth.terrarium.botarium.common.item.base.ItemContainer;
import earth.terrarium.botarium.common.item.base.ItemSnapshot;
import earth.terrarium.botarium.fabric.item.SingleItemSlot;
import earth.terrarium.botarium.util.Snapshotable;
import earth.terrarium.botarium.util.Updatable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import org.apache.commons.lang3.NotImplementedException;

public class FabricItemContainer
extends SnapshotParticipant<ItemSnapshot>
implements SlottedStorage<ItemVariant> {
    protected final ItemContainer container;

    public static FabricItemContainer of(ItemContainer container) {
        return container == null ? null : new FabricItemContainer(container);
    }

    public FabricItemContainer(ItemContainer container) {
        this.container = container;
    }

    public int getSlotCount() {
        return this.container.getSlots();
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        if (slot < 0 || slot >= this.container.getSlots()) {
            throw new IndexOutOfBoundsException("Slot index out of bounds: " + slot);
        }
        return new SingleItemSlot(slot, this);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        return this.container.insertItem(resource.toStack((int)maxAmount), false).method_7947();
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        this.updateSnapshots(transaction);
        long extracted = 0L;
        for (int i = 0; !(i >= this.container.getSlots() || resource.matches(this.container.getStackInSlot(i)) && (extracted += (long)this.container.extractFromSlot(i, (int)maxAmount, false).method_7947()) >= maxAmount); ++i) {
        }
        return extracted;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return new Iterator<StorageView<ItemVariant>>(){
            private int slot = 0;

            @Override
            public boolean hasNext() {
                return this.slot < FabricItemContainer.this.container.getSlots();
            }

            @Override
            public StorageView<ItemVariant> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Element does not exist at index " + this.slot);
                }
                return FabricItemContainer.this.getSlot(this.slot++);
            }
        };
    }

    protected ItemSnapshot createSnapshot() {
        ItemContainer itemContainer = this.container;
        if (itemContainer instanceof Snapshotable) {
            Snapshotable snapshotable = (Snapshotable)((Object)itemContainer);
            return (ItemSnapshot)snapshotable.createSnapshot();
        }
        throw new NotImplementedException("Container does not implement Snapshotable of ItemSnapshot");
    }

    protected void readSnapshot(ItemSnapshot snapshot) {
        snapshot.loadSnapshot();
    }

    protected void onFinalCommit() {
        ItemContainer itemContainer = this.container;
        if (itemContainer instanceof Updatable) {
            Updatable updatable = (Updatable)((Object)itemContainer);
            updatable.update();
        }
    }
}

