/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.fabric.item;

import earth.terrarium.botarium.common.item.base.ItemContainer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PlatformItemContainer(Storage<ItemVariant> storage) implements ItemContainer
{
    @Nullable
    public static PlatformItemContainer of(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        Storage itemStorage = (Storage)ItemStorage.SIDED.find(level, pos, state, entity, (Object)direction);
        return itemStorage == null ? null : new PlatformItemContainer((Storage<ItemVariant>)itemStorage);
    }

    @Override
    public int getSlots() {
        AtomicInteger count = new AtomicInteger();
        this.storage.iterator().forEachRemaining(t -> count.incrementAndGet());
        return count.get();
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        Iterator it = this.storage.iterator();
        for (int i = 0; i < slot; ++i) {
            it.next();
        }
        return ((ItemVariant)((StorageView)it.next()).getResource()).toStack();
    }

    @Override
    public int getSlotLimit(int slot) {
        Iterator it = this.storage.iterator();
        for (int i = 0; i < slot; ++i) {
            it.next();
        }
        return (int)((StorageView)it.next()).getCapacity();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return true;
    }

    @Override
    @NotNull
    public class_1799 insertItem(@NotNull class_1799 stack, boolean simulate) {
        try (Transaction tx = Transaction.openOuter();){
            long inserted = this.storage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)tx);
            class_1799 result = stack.method_46651((int)inserted);
            if (!simulate) {
                tx.commit();
            }
            class_1799 class_17992 = result;
            return class_17992;
        }
    }

    @Override
    @NotNull
    public class_1799 insertIntoSlot(int slotIndex, @NotNull class_1799 stack, boolean simulate) {
        Storage<ItemVariant> storage = this.storage;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            try (Transaction tx = Transaction.openOuter();){
                SingleSlotStorage slotStorage = slottedStorage.getSlot(slotIndex);
                long inserted = slotStorage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)tx);
                class_1799 result = stack.method_46651((int)inserted);
                if (!simulate) {
                    tx.commit();
                }
                class_1799 class_17992 = result;
                return class_17992;
            }
        }
        return this.insertItem(stack, simulate);
    }

    @Override
    @NotNull
    public class_1799 extractItem(int amount, boolean simulate) {
        try (Transaction tx = Transaction.openOuter();){
            class_1799 class_17992;
            ItemVariant itemVariant = null;
            int amountExtracted = 0;
            Iterator it = this.storage.nonEmptyIterator();
            while (it.hasNext()) {
                StorageView view = (StorageView)it.next();
                if (itemVariant == null) {
                    itemVariant = (ItemVariant)view.getResource();
                }
                if (!itemVariant.equals(view.getResource()) || (amountExtracted += (int)view.extract((Object)itemVariant, (long)(amount - amountExtracted), (TransactionContext)tx)) < amount) continue;
                break;
            }
            if (itemVariant == null || amountExtracted == 0) {
                class_17992 = class_1799.field_8037;
                return class_17992;
            }
            if (!simulate) {
                tx.commit();
            }
            class_17992 = itemVariant.toStack(amountExtracted);
            return class_17992;
        }
    }

    @Override
    @NotNull
    public class_1799 extractFromSlot(int slot, int amount, boolean simulate) {
        Storage<ItemVariant> storage = this.storage;
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            try (Transaction tx = Transaction.openOuter();){
                SingleSlotStorage slotStorage = slottedStorage.getSlot(slot);
                long extracted = slotStorage.extract((Object)((ItemVariant)slotStorage.getResource()), (long)amount, (TransactionContext)tx);
                if (extracted > 0L) {
                    class_1799 result = ((ItemVariant)slotStorage.getResource()).toStack((int)extracted);
                    if (!simulate) {
                        tx.commit();
                    }
                    class_1799 class_17992 = result;
                    return class_17992;
                }
            }
        }
        return this.extractItem(amount, simulate);
    }

    @Override
    public boolean isEmpty() {
        Iterator it = this.storage.nonEmptyIterator();
        while (it.hasNext()) {
            if (((StorageView)it.next()).getAmount() <= 0L) continue;
            return false;
        }
        return true;
    }

    public void method_5448() {
        for (StorageView itemVariantStorageView : this.storage) {
            itemVariantStorageView.extract((Object)((ItemVariant)itemVariantStorageView.getResource()), itemVariantStorageView.getAmount(), (TransactionContext)Transaction.openOuter());
        }
    }
}

